/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.util.Utility;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Comparator;

public class PlayField {
    private SpriteGroup[] groups;
    private Background background;
    private CollisionManager[] collisions;
    private Sprite[] cacheSprite;
    private Comparator comparator;

    public PlayField(Background background) {
        this.background = background;
        SpriteGroup extra = new SpriteGroup("Extra Group");
        extra.setBackground(background);
        this.groups = new SpriteGroup[1];
        this.groups[0] = extra;
        this.collisions = new CollisionManager[0];
        this.cacheSprite = new Sprite[0];
    }

    public PlayField() {
        this(Background.getDefaultBackground());
    }

    public void add(Sprite extra) {
        this.groups[this.groups.length - 1].add(extra);
    }

    public SpriteGroup addGroup(SpriteGroup group) {
        SpriteGroup extra = this.groups[this.groups.length - 1];
        this.groups = (SpriteGroup[])Utility.cut(this.groups, this.groups.length - 1);
        this.groups = (SpriteGroup[])Utility.expand(this.groups, 2);
        group.setBackground(this.background);
        this.groups[this.groups.length - 2] = group;
        this.groups[this.groups.length - 1] = extra;
        return group;
    }

    public boolean removeGroup(SpriteGroup group) {
        for (int i = 0; i < this.groups.length - 1; ++i) {
            if (this.groups[i] != group) continue;
            this.groups = (SpriteGroup[])Utility.cut(this.groups, i);
            CollisionManager collisionGroup = this.getCollisionGroup(group);
            if (collisionGroup != null) {
                do {
                    this.removeCollisionGroup(collisionGroup);
                } while ((collisionGroup = this.getCollisionGroup(group)) != null);
            }
            return true;
        }
        return false;
    }

    public SpriteGroup getGroup(String name) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].getName().equals(name)) continue;
            return this.groups[i];
        }
        return null;
    }

    public SpriteGroup[] getGroups() {
        return this.groups;
    }

    public SpriteGroup getExtraGroup() {
        return this.groups[this.groups.length - 1];
    }

    public void clearPlayField() {
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i].clear();
        }
    }

    public void addCollisionGroup(SpriteGroup group1, SpriteGroup group2, CollisionManager collisionGroup) {
        if (this.getCollisionGroup(group1, group2) != null) {
            System.err.println("WARNING: " + group1.getName() + " <-> " + group2.getName() + " already have a CollisionManager");
            System.err.println("CollisionGroup insertions operation continued");
        }
        this.collisions = (CollisionManager[])Utility.expand(this.collisions, 1);
        collisionGroup.setCollisionGroup(group1, group2);
        this.collisions[this.collisions.length - 1] = collisionGroup;
    }

    public boolean removeCollisionGroup(CollisionManager collisionGroup) {
        for (int i = 0; i < this.collisions.length; ++i) {
            if (this.collisions[i] != collisionGroup) continue;
            this.collisions = (CollisionManager[])Utility.cut(this.collisions, i);
            return true;
        }
        return false;
    }

    public CollisionManager getCollisionGroup(SpriteGroup group1, SpriteGroup group2) {
        for (int i = 0; i < this.collisions.length; ++i) {
            if (this.collisions[i].getGroup1() != group1 || this.collisions[i].getGroup2() != group2) continue;
            return this.collisions[i];
        }
        return null;
    }

    public CollisionManager getCollisionGroup(SpriteGroup group) {
        for (int i = 0; i < this.collisions.length; ++i) {
            if (this.collisions[i].getGroup1() != group && this.collisions[i].getGroup2() != group) continue;
            return this.collisions[i];
        }
        return null;
    }

    public CollisionManager[] getCollisionGroups() {
        return this.collisions;
    }

    public void update(long elapsedTime) {
        this.updateSpriteGroups(elapsedTime);
        this.updateBackground(elapsedTime);
        this.checkCollisions();
    }

    protected void updateBackground(long elapsedTime) {
        this.background.update(elapsedTime);
    }

    protected void updateSpriteGroups(long elapsedTime) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].isActive()) continue;
            this.groups[i].update(elapsedTime);
        }
    }

    protected void checkCollisions() {
        for (int i = 0; i < this.collisions.length; ++i) {
            if (!this.collisions[i].isActive()) continue;
            this.collisions[i].checkCollision();
        }
    }

    public void render(Graphics2D g) {
        this.renderBackground(g);
        if (this.comparator == null) {
            this.renderSpriteGroups(g);
        } else {
            this.renderSpriteGroups(g, this.comparator);
        }
    }

    protected void renderBackground(Graphics2D g) {
        this.background.render(g);
    }

    protected void renderSpriteGroups(Graphics2D g) {
        for (int i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].isActive()) continue;
            this.groups[i].render(g);
        }
    }

    protected void renderSpriteGroups(Graphics2D g, Comparator c) {
        int i;
        int num = 0;
        int len = this.cacheSprite.length;
        if (len == 0) {
            this.cacheSprite = new Sprite[100];
            len = this.cacheSprite.length;
        }
        for (i = 0; i < this.groups.length; ++i) {
            if (!this.groups[i].isActive()) continue;
            Sprite[] member = this.groups[i].getSprites();
            int size = this.groups[i].getSize();
            for (int j = 0; j < size; ++j) {
                if (!member[j].isActive() || !member[j].isOnScreen()) continue;
                if (num >= len) {
                    this.cacheSprite = (Sprite[])Utility.expand(this.cacheSprite, 20);
                    len = this.cacheSprite.length;
                }
                this.cacheSprite[num++] = member[j];
            }
        }
        Arrays.sort(this.cacheSprite, 0, num, c);
        for (i = 0; i < num; ++i) {
            this.cacheSprite[i].render(g);
        }
    }

    public void clearCache() {
        this.cacheSprite = null;
        this.cacheSprite = new Sprite[0];
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background backgr) {
        this.background = backgr;
        if (this.background == null) {
            this.background = Background.getDefaultBackground();
        }
        for (int i = 0; i < this.groups.length; ++i) {
            this.groups[i].setBackground(backgr);
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator c) {
        this.comparator = c;
    }
}

