/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;

public abstract class CollisionGroup
extends BasicCollisionGroup {
    public static final int LEFT_RIGHT_COLLISION = 1;
    public static final int RIGHT_LEFT_COLLISION = 2;
    public static final int TOP_BOTTOM_COLLISION = 4;
    public static final int BOTTOM_TOP_COLLISION = 8;
    protected Sprite sprite1;
    protected Sprite sprite2;
    protected int collisionSide;
    protected double collisionX1;
    protected double collisionY1;
    protected double collisionX2;
    protected double collisionY2;

    public boolean isCollide(Sprite s1, Sprite s2, CollisionShape shape1, CollisionShape shape2) {
        if (super.isCollide(s1, s2, shape1, shape2)) {
            this.sprite1 = s1;
            this.sprite2 = s2;
            this.collisionSide = 0;
            this.collisionX1 = s1.getOldX();
            this.collisionY1 = s1.getOldY();
            this.collisionX2 = s2.getOldX();
            this.collisionY2 = s2.getOldY();
            double speedX1 = s1.getX() - this.collisionX1;
            double speedY1 = s1.getY() - this.collisionY1;
            double speedX2 = s2.getX() - this.collisionX2;
            double speedY2 = s2.getY() - this.collisionY2;
            double oldx1 = shape1.getX();
            double oldy1 = shape1.getY();
            double oldx2 = shape2.getX();
            double oldy2 = shape2.getY();
            shape1.move(-(speedX1 / 2.0), -(speedY1 / 2.0));
            shape2.move(-(speedX2 / 2.0), -(speedY2 / 2.0));
            if (!shape1.intersects(shape2)) {
                shape1.setLocation(oldx1, oldy1);
                shape2.setLocation(oldx2, oldy2);
                shape1.move(-(speedX1 / 4.0), -(speedY1 / 4.0));
                shape2.move(-(speedX2 / 4.0), -(speedY2 / 4.0));
                if (!shape1.intersects(shape2)) {
                    shape1.setLocation(oldx1, oldy1);
                    shape2.setLocation(oldx2, oldy2);
                }
            }
            CollisionRect iRect = CollisionManager.getIntersectionRect(shape1.getX(), shape1.getY(), shape1.getWidth(), shape1.getHeight(), shape2.getX(), shape2.getY(), shape2.getWidth(), shape2.getHeight());
            this.collisionSide = iRect.width <= iRect.height ? (shape1.getX() < shape2.getX() ? 2 : 1) : (shape1.getY() < shape2.getY() ? 8 : 4);
            return true;
        }
        return false;
    }

    public void revertPosition1() {
        if ((this.collisionSide & 1) != 0 || (this.collisionSide & 2) != 0) {
            this.sprite1.forceX(this.collisionX1);
        }
        if ((this.collisionSide & 4) != 0 || (this.collisionSide & 8) != 0) {
            this.sprite1.forceY(this.collisionY1);
        }
    }

    public void revertPosition2() {
        if ((this.collisionSide & 1) != 0 || (this.collisionSide & 2) != 0) {
            this.sprite2.forceX(this.collisionX2);
        }
        if ((this.collisionSide & 4) != 0 || (this.collisionSide & 8) != 0) {
            this.sprite2.forceY(this.collisionY2);
        }
    }

    public Sprite getSprite1() {
        return this.sprite1;
    }

    public Sprite getSprite2() {
        return this.sprite2;
    }

    public int getCollisionSide() {
        return this.collisionSide;
    }

    public void printCollisionSide() {
        String side = "Collision Side ->";
        if ((this.collisionSide & 1) != 0) {
            side = side + " Left<->Right";
        }
        if ((this.collisionSide & 2) != 0) {
            side = side + " Right<->Left";
        }
        if ((this.collisionSide & 4) != 0) {
            side = side + " Top<->Bottom";
        }
        if ((this.collisionSide & 8) != 0) {
            side = side + " Bottom<->Top";
        }
    }
}

