/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.Enemy;
import biege.GUI;
import biege.Position;
import java.awt.Color;
import java.awt.Graphics;

public class Ghost
extends Enemy {
    private int ghostWidth = 8;
    private double ghostSpeed = 2.3;
    private int dashWaitDuration;
    private int moveCount = this.dashWaitDuration = 30;
    private Color myColour = Color.white;

    public Ghost(Position p) {
        super(p);
    }

    public Ghost(Position p, int w, double speed, int duration, Color colour) {
        super(p);
        this.ghostWidth = w;
        this.ghostSpeed = speed;
        this.moveCount = this.dashWaitDuration = duration;
        this.myColour = colour;
    }

    public void draw(Graphics g, int viewW, int viewH) {
        g.setColor(this.myColour);
        g.fillOval(this.scaleX(viewW) - Element.scaleWidth(viewW, this.ghostWidth / 2), this.scaleY(viewH) - Element.scaleHeight(viewH, this.ghostWidth / 2), Element.scaleWidth(viewW, this.ghostWidth), Element.scaleHeight(viewH, this.ghostWidth));
        if (this.moveCount < 0) {
            g.setColor(Color.black);
            g.drawOval(this.scaleX(viewW) - Element.scaleWidth(viewW, this.ghostWidth / 2), this.scaleY(viewH) - Element.scaleHeight(viewH, this.ghostWidth / 2), Element.scaleWidth(viewW, this.ghostWidth), Element.scaleHeight(viewH, this.ghostWidth));
            g.fillOval(this.scaleX(viewW) - 2, this.scaleY(viewH), 1, 1);
            g.fillOval(this.scaleX(viewW) + 2, this.scaleY(viewH), 1, 1);
        }
    }

    public void advance(GUI tempGui) {
        --this.moveCount;
        if (this.moveCount > 0 && Position.distance(tempGui.getPlayer().getPosition(), this.getPosition()) > 0.0) {
            this.changePosition(Position.calculateNewPosition(this.getPosition(), tempGui.getPlayer().getPosition(), this.ghostSpeed));
        }
        if (this.moveCount < -this.dashWaitDuration) {
            this.moveCount = this.dashWaitDuration;
        }
    }

    public double getGurth() {
        return this.ghostWidth / 2;
    }

    public void delete() {
        if (this.moveCount <= 0) {
            super.delete();
        }
    }

    public boolean isSolid() {
        return false;
    }

    public void talk(GUI tempGui) {
    }

    public void onDeath(GUI tempGui) {
        super.onDeath(tempGui);
        tempGui.getPlayer().increaseScore(5);
    }
}

