/*
 * Decompiled with CFR 0.152.
 */
package biege;

import biege.Element;
import biege.GUI;
import biege.Position;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class SpikePit
extends Element {
    private int width;
    private int height;
    private Color colour;
    private static Image SPRITE;
    private static String SPIKE_IMAGE_LOCATION;

    public SpikePit(Position p, int w, int h, Color c) {
        super(p);
        this.width = w;
        this.height = h;
        this.colour = c;
        if (SPRITE == null) {
            SPRITE = Element.loadImage(SPIKE_IMAGE_LOCATION);
        }
    }

    public void draw(Graphics g, int viewW, int viewH) {
        g.setColor(Color.black);
        g.drawRect(this.scaleX(viewW) + 1, this.scaleY(viewH) + 1, Element.scaleWidth(viewW, this.width) - 1, Element.scaleHeight(viewH, this.height) - 1);
        g.setColor(Color.white);
        g.drawRect(this.scaleX(viewW), this.scaleY(viewH), Element.scaleWidth(viewW, this.width), Element.scaleHeight(viewH, this.height));
        if (SPRITE != null) {
            Element.drawImage(SPRITE, g, this.scaleX(viewW), this.scaleY(viewH), Element.scaleWidth(viewW, this.width), Element.scaleHeight(viewH, this.height));
        }
    }

    public void interact(Element e) {
        double west = this.getPosition().getX() - e.getGurth();
        double east = this.getPosition().getX() + (double)this.width + e.getGurth();
        double north = this.getPosition().getY() - e.getGurth();
        double south = this.getPosition().getY() + (double)this.height + e.getGurth();
        if (Position.isInRectangle(e.getPosition(), new Position(west, north), new Position(east, south))) {
            e.hurt();
        }
    }

    public void advance(GUI tempGui) {
    }

    public void talk(GUI tempGui) {
    }

    static {
        SPIKE_IMAGE_LOCATION = "spikes.gif";
    }
}

