package biege;
import java.awt.Graphics;
import java.awt.Color;


public class Ghost extends Enemy
{

    private int ghostWidth = 8;
    private double ghostSpeed = 2.3;
    private int dashWaitDuration = 30;
    private int moveCount = dashWaitDuration;
    private Color myColour = Color.white;

    public Ghost(Position p)
    {
      super(p);
    }

    public Ghost(Position p, int w, double speed, int duration, Color colour)
    {
      super(p);
      ghostWidth = w;
      ghostSpeed = speed;
      dashWaitDuration = duration;
      moveCount = dashWaitDuration;
      myColour = colour;

    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      g.setColor(myColour);
      g.fillOval(scaleX(viewW) - Element.scaleWidth(viewW, ghostWidth / 2),
                 scaleY(viewH) - Element.scaleHeight(viewH, ghostWidth / 2),
                 Element.scaleWidth(viewW, ghostWidth),Element.scaleHeight(viewH, ghostWidth) );
      if (moveCount < 0)
      {

        g.setColor(Color.black);
        g.drawOval(scaleX(viewW) - Element.scaleWidth(viewW, ghostWidth / 2),
                  scaleY(viewH) - Element.scaleHeight(viewH, ghostWidth / 2),
                  Element.scaleWidth(viewW, ghostWidth),Element.scaleHeight(viewH, ghostWidth) );
        g.fillOval(scaleX(viewW) - 2, scaleY(viewH), 1, 1);
        g.fillOval(scaleX(viewW) + 2, scaleY(viewH), 1, 1);
      }
    }


    public void advance(GUI tempGui)
    {
      moveCount--;
      if (moveCount > 0 && Position.distance(tempGui.getPlayer().getPosition(), getPosition()) > 0)
        changePosition(Position.calculateNewPosition(getPosition(), tempGui.getPlayer().getPosition(), ghostSpeed));
      if (moveCount < -dashWaitDuration)
        moveCount = dashWaitDuration;

    }

    public double getGurth()
    {
      return (ghostWidth/2);
    }

    public void delete ()
    {
      if (moveCount > 0) {}
      else
        super.delete();
    }

    public boolean isSolid()
    {
      return false;
    }

    public void talk (GUI tempGui) { }

    public void onDeath(GUI tempGui)
    {
      super.onDeath(tempGui);
      tempGui.getPlayer().increaseScore(5);
    }
}