package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;
import java.applet.AudioClip;

public class Player extends Element
{
    private static double xStep = 2.8;
    private static double yStep = 2.4;

    private boolean smiting = false;
    private static boolean readyToSmite = true;
    private static double STRIKE_REACH = 4.8;
    public static int HURT_RECOVER = 18;
    public static int MAX_HEALTH = 3;
    public static int INC_MAX_HEALTH_SCORE = 250;
    private static String[] LEVEL_UP = {"Level Up!", "Max health increased",
                                        "Health restored"};

    public static AudioClip SWING_SOUND = Element.loadAudioClip("file:sound/slice.wav");
    public static AudioClip HURT_SOUND = Element.loadAudioClip("file:sound/hit.wav");

    private static Image[] sprites = new Image[16];
    private Image currentSprite;
    private static int STAB_FRAME = 3;
    private Angle frameCount = new Angle(0);

    private boolean controlsEngaged = true;
    private boolean showLevelUpMsg = false;
    private boolean[] crystalPouch;
    private final static boolean[] EMPTY_POUCH = {false, false, false, false,
                                                  false, false, false, false,
                                                  false, false, false, false,
                                                  false, false, false, false,
                                                  false, false, false, false};

    private boolean finnished = false;
    private int health = MAX_HEALTH;
    private int score;
    private int invincibility =0;
    private int direction = Position.DIRECTION_SOUTH;
    private double gurth = 2.83;

    private int width = 10;
    private int height = 13;

    private Position facing;

    public Player(Position p)
    {

      super(p);
      facing = p;
      loadAllSprites();

      emptyPouch();

      finnished = false;
      MAX_HEALTH = 3;
      health = MAX_HEALTH;
      INC_MAX_HEALTH_SCORE = 250;
      score = 0;
      invincibility =0;
      direction = Position.DIRECTION_SOUTH;
    }

    public void emptyPouch()
    {
      crystalPouch = EMPTY_POUCH;
    }

    private void loadAllSprites()
    {
      sprites[Position.DIRECTION_NORTH] = Element.loadImage("dwarf_north_2.gif");
      sprites[1] = Element.loadImage("dwarf_north_1.gif");
      sprites[2] = Element.loadImage("dwarf_north_3.gif");
      sprites[3] = Element.loadImage("dwarf_north_4.gif");

      sprites[Position.DIRECTION_SOUTH] = Element.loadImage("dwarf_south_2.gif");
      sprites[5] = Element.loadImage("dwarf_south_1.gif");
      sprites[6] = Element.loadImage("dwarf_south_3.gif");
      sprites[7] = Element.loadImage("dwarf_south_4.gif");

      sprites[Position.DIRECTION_EAST] = Element.loadImage("dwarf_east_2.gif");
      sprites[9] = Element.loadImage("dwarf_east_1.gif");
      sprites[10] = Element.loadImage("dwarf_east_3.gif");
      sprites[11] = Element.loadImage("dwarf_east_4.gif");

      sprites[Position.DIRECTION_WEST] = Element.loadImage("dwarf_west_2.gif");
      sprites[13] = Element.loadImage("dwarf_west_1.gif");
      sprites[14] = Element.loadImage("dwarf_west_3.gif");
      sprites[15] = Element.loadImage("dwarf_west_4.gif");

      currentSprite = sprites[direction + 1];
    }

    public void draw(Graphics g, int viewW, int viewH)
    {
      //See if you are flashing snd should be invisible
      if (invincibility % 2 == 1)
        return;

      int x = scaleX(viewW);
      int y = scaleY(viewH);

          g.setColor(Color.black);
          g.drawOval(x, y, 2, 2);

        if(currentSprite != null)
          Element.drawImage(currentSprite, g, x  -  Element.scaleWidth(viewW, (int)width/2), y -  Element.scaleHeight(viewH, (int)height/2),
                                                 Element.scaleWidth(viewW, width), Element.scaleHeight(viewH, height));

      if (smiting)
      {
        if (SWING_SOUND != null)
          SWING_SOUND.play();

        g.setColor(Color.gray);
        g.drawOval(Element.scaleX(viewW, facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH),
                   Element.scaleY(viewH, facing.getY()) -  Element.scaleHeight(viewH, (int)STRIKE_REACH),
                   Element.scaleWidth(viewW, (int)STRIKE_REACH * 2),  Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));

        g.setColor(Color.lightGray);
        g.drawOval(Element.scaleX(viewW, facing.getX()) - Element.scaleWidth(viewW, (int)STRIKE_REACH) + 1,
                   Element.scaleY(viewH, facing.getY()) -  Element.scaleHeight(viewH, (int)STRIKE_REACH) + 1,
                   Element.scaleWidth(viewW, (int)STRIKE_REACH * 2),  Element.scaleHeight(viewH, (int)STRIKE_REACH * 2));

      }
    }

    public double getGurth()
    {
      return height/2;
    }

    public int getDirection()
    {
      return direction;
    }

    public static void getReadyToSmite()
    {
      readyToSmite = true;
    }

    public void advance(GUI tempGui)
    {

      if (showLevelUpMsg)
      {
        tempGui.setTextBox(new TextBox(LEVEL_UP));
        showLevelUpMsg = false;
      }

      if (!controlsEngaged)
        return;

      //Cant stay invincible forever
      if (invincibility > 0)
        invincibility--;

      //Do not sing continouosly
      if (smiting)
      {
        smiting = false;
      }

      if (tempGui.isControlPressed() && readyToSmite)
      {
        smite();
      }

      if (tempGui.isControlPressed())
        currentSprite = sprites[direction + STAB_FRAME];
      else
        {
          handleDirctions (tempGui);
          faceDirection();

        }

      // /**** Hurt each other HURRAY
      Player2 p2 = tempGui.getPlayer2();
      if (smiting  && Position.distance(facing, p2.getPosition()) < STRIKE_REACH + p2.getGurth())
              p2.hurt();
      //*/

    }//advance

    public boolean hasAllCrystals()
    {
      for (int i = 0; i < crystalPouch.length; i++)
      {
        if (!crystalPouch[i])
          return false;
      }
      return true;
    }//hasAllCrystals

  public boolean hasCystal(int i)
  {
    return crystalPouch[i];
  }//hasCrystal

    public void giveCrystal(int i)
    {
      crystalPouch[i] = true;
      increaseScore(25);
    }//giveCrystal

    public void faceDirection()
    {
      if (direction == Position.DIRECTION_NORTH)
        facing = new Position (getPosition().getX(), getPosition().getY() - 8.5);
      if (direction == Position.DIRECTION_SOUTH)
        facing = new Position (getPosition().getX(), getPosition().getY() + 8.5);
      if (direction == Position.DIRECTION_EAST)
        facing = new Position (getPosition().getX() + 7.5, getPosition().getY());
      if (direction == Position.DIRECTION_WEST)
        facing = new Position (getPosition().getX() - 7.5, getPosition().getY());
    }

    public Position directlyFacing()
    {
      return facing;
    }

    public int getHealth()
    {
      return health;
    }


    public void hurt()
    {
      if(invincibility <= 0)
      {
        if (HURT_SOUND != null)
          HURT_SOUND.play();
        health--;
        invincibility = HURT_RECOVER;
      }
    }

    public void increaseScore(int i)
    {
      score = score + i;
      if (score >= INC_MAX_HEALTH_SCORE && MAX_HEALTH < 7)
      {
        MAX_HEALTH++;
        INC_MAX_HEALTH_SCORE = 2*INC_MAX_HEALTH_SCORE;
        this.fullHeal();
        showLevelUpMsg = true;
      }

    }

    public int getScore()
    {
      return score;
    }


    public void fullHeal()
    {
      health = MAX_HEALTH;
    }


    public boolean isDead()
    {
      return health <= 0;
    }

    public boolean finnished()
    {
      return finnished;
    }

    public void beatGame()
    {
      finnished = true;
    }

    private void flipFrame()
    {
      int frame = 0;
      frameCount.increment(Math.PI / 2);
      frame = direction + (int)Math.sin(frameCount.get()) + 1;
      currentSprite = sprites[frame];
    }

    private void handleDirctions (GUI tempGui)
    {
      boolean shouldFlip = smiting;
      double dx = 0;
      double dy = 0;

      if (tempGui.isUpPressed())
      {
        dy = -yStep;
        direction = Position.DIRECTION_NORTH;
        shouldFlip = true;
      }

      if (tempGui.isLeftPressed())
      {
        dx = -xStep;
        direction = Position.DIRECTION_WEST;
        shouldFlip = true;
      }


      if (tempGui.isRightPressed())
      {
        dx = xStep;
        direction = Position.DIRECTION_EAST;
        shouldFlip = true;
      }


      if (tempGui.isDownPressed())
      {
        dy = yStep;
        direction = Position.DIRECTION_SOUTH;
        shouldFlip = true;
      }



      if (shouldFlip)
      {
        changePosition(new Position(getPosition().getX() + dx, getPosition().getY() + dy));
        flipFrame();
      }
      else
        {
          currentSprite = sprites[direction + 1];
        }

    }

    private void smite()
    {
      readyToSmite = false;
      smiting = true;
    }


    public void interact (Element e)
    {
      if (smiting  && e.isBad() && Position.distance(facing, e.getPosition()) < STRIKE_REACH + e.getGurth())
              e.delete();
    }

    public void disengageControls()
    {
      controlsEngaged = false;
    }

    public void engageControls()
    {
      controlsEngaged = true;
    }

    public int countCrystals()
    {
      int count = 0;
      for (int i = 0; i < crystalPouch.length; i++)
      {
        if (crystalPouch[i])
          count++;
      }
      return count;
    }



}