package biege;
import java.awt.*;
import javax.swing.*;
import java.util.ArrayList;

public class ScrollView extends JPanel
{
  GUI myGui;

  private static int CROSS_WIDTH = 20;
  private static int CROSS_HEIGHT = 20;
  private static int CROSS_THICK = 8;

  private Image on;
  private Image off;

  private double x;
  private double y;
  private double xRel;
  private double yRel;

  public ScrollView(GUI caller, Image offImg, Image onImg, double startX, double startY,
                    double relX, double relY)
  {
    super();
    this.setBackground(Color.black);
    myGui = caller;
    off = offImg;
    on = onImg;
    x = startX;
    y = startY;
    xRel = relX;
    yRel = relY;
  }


  public void changeX(double dX)

  {

    x += dX;

  }


  public void changeY(double dY)
  {

    y += dY;

  }


  public void paintComponent(Graphics g)
  {

    super.paintComponent(g);

      Element.drawImage(off, g, Element.scaleX(this.getWidth(), x), Element.scaleY(this.getHeight(), y),
      this.getWidth(), this.getHeight());


      Element.drawImage(on, g, Element.scaleX(this.getWidth(), x + xRel), Element.scaleY(this.getHeight(), y + yRel),
                                              this.getWidth(), this.getHeight());

      for (int cross = 0; cross < myGui.getPlayerHealth(); cross++)
          showRedCross (g, 5 + cross * (CROSS_WIDTH + 5));

        if (myGui.multiplayOn())
        {
          for (int cross = 0; cross < myGui.getPlayer2Health(); cross++)
            showBlueCross (g, 5 + cross * (CROSS_WIDTH + 5));
        }

        g.setColor(Color.black);
        g.drawString("Score: " + myGui.getPlayer().getScore(), 7, getHeight() - CROSS_HEIGHT - 21);
        g.setColor(Color.white);
        g.drawString("Score: " + myGui.getPlayer().getScore(), 8, getHeight() - CROSS_HEIGHT - 20);

  }

  public void showRedCross (Graphics g, int x)
  {
    g.setColor(Color.red);
    int y = getHeight() - CROSS_HEIGHT - 5;
    g.fillRect(x, y + (int)(CROSS_HEIGHT - CROSS_THICK)/2, CROSS_WIDTH, CROSS_THICK);
    g.fillRect(x + (int)(CROSS_WIDTH - CROSS_THICK)/2, y, CROSS_THICK, CROSS_HEIGHT);

  }

  public void showBlueCross (Graphics g, int x)
  {
    g.setColor(Color.blue);
    int y = 5;
    g.fillRect(x, y + (int)(CROSS_HEIGHT - CROSS_THICK)/2, CROSS_WIDTH, CROSS_THICK);
    g.fillRect(x + (int)(CROSS_WIDTH - CROSS_THICK)/2, y, CROSS_THICK, CROSS_HEIGHT);

  }

}

