package biege;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;

public class SpikePit extends Element
{

    private int width;
    private int height;
    private Color colour;


    private static Image SPRITE;
    private static String SPIKE_IMAGE_LOCATION = "spikes.gif";

    public SpikePit(Position p, int w, int h, Color c)
    {
      super(p);
      width = w;
      height = h;
      colour = c;

      if (SPRITE == null)
      {
        SPRITE = Element.loadImage(SPIKE_IMAGE_LOCATION);
      }

    }

    public void draw(Graphics g, int viewW, int viewH)
    {

      g.setColor(Color.black);
      g.drawRect(scaleX(viewW) + 1, scaleY(viewH) + 1,
                 Element.scaleWidth(viewW, width) - 1, Element.scaleHeight(viewH, height) - 1);
      g.setColor(Color.white);
      g.drawRect(scaleX(viewW), scaleY(viewH),
                 Element.scaleWidth(viewW, width), Element.scaleHeight(viewH, height));

      if(SPRITE != null)
      Element.drawImage(SPRITE, g, scaleX(viewW), scaleY(viewH),
                        Element.scaleWidth(viewW, width), Element.scaleHeight(viewH, height));


    }

    public void interact(Element e)
    {
      double west = getPosition().getX() - e.getGurth();
      double east = getPosition().getX() + width + e.getGurth();
      double north = getPosition().getY() - e.getGurth();
      double south = getPosition().getY() + height +  e.getGurth();

      if (Position.isInRectangle(e.getPosition(), new Position(west, north), new Position (east, south)))
        e.hurt();

    }

    public void advance(GUI tempGui)
    {
    }

    public void talk (GUI tempGui) { }
}