package biege;
import java.util.ArrayList;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.Image;
import java.applet.Applet;
import java.applet.AudioClip;
import java.net.URL;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
public class WorldData extends Object
{


  private static String[][] dialogue;

  private static String MAIN_THEME_LOCATION = "file:sound/main.wav";
  private static String KING_THEME_LOCATION = "file:sound/king.wav";
  private static String CASTLE_THEME_LOCATION = "file:sound/castle.wav";
  private static String CURRENT_SONG_LOACTION = "";
  private static AudioClip song;

  private static Image BOSS = Element.loadImage("boss.gif");
  private static Image THRONE = Element.loadImage("throne.gif");
  private static Image CAVEA1 = Element.loadImage("cavea1.gif");
  private static Image CAVEA2 = Element.loadImage("cavea2.gif");
  private static Image CAVEB1 = Element.loadImage("caveb1.gif");
  private static Image CAVEB2 = Element.loadImage("caveb2.gif");
  private static Image DESERTA1 = Element.loadImage("deserta1.gif");
  private static Image DESERTA2 = Element.loadImage("deserta2.gif");
  private static Image DESERTB1 = Element.loadImage("desertb1.gif");
  private static Image DESERTB2 = Element.loadImage("desertb2.gif");
  private static Image DUNGEONA1 = Element.loadImage("dungeona1.gif");
  private static Image DUNGEONB1 = Element.loadImage("dungeonb1.gif");
  private static Image DUNGEONC1 = Element.loadImage("dungeonc1.gif");
  private static Image ENTRENCE = Element.loadImage("entrence.gif");
  private static Image FOREST = Element.loadImage("forest.gif");
  private static Image FORESTA1 = Element.loadImage("foresta1.gif");
  private static Image FORESTA2 = Element.loadImage("foresta2.gif");
  private static Image FORESTA3 = Element.loadImage("foresta3.gif");
  private static Image FORESTA4 = Element.loadImage("foresta4.gif");
  private static Image FORESTB1 = Element.loadImage("forestb1.gif");
  private static Image FORESTB2 = Element.loadImage("forestb2.gif");
  private static Image FORESTB3 = Element.loadImage("forestb3.gif");
  private static Image FORESTB4 = Element.loadImage("forestb4.gif");
  private static Image FORESTC1 = Element.loadImage("forestc1.gif");
  private static Image FORESTC2 = Element.loadImage("forestc2.gif");
  private static Image FORESTC3 = Element.loadImage("forestc3.gif");
  private static Image FORESTC4 = Element.loadImage("forestc4.gif");
  private static Image FORESTD1 = Element.loadImage("forestd1.gif");
  private static Image FORESTD2 = Element.loadImage("forestd2.gif");
  private static Image FORESTD3 = Element.loadImage("forestd3.gif");
  private static Image FORESTD4 = Element.loadImage("forestd4.gif");
  private static Image GRAVE = Element.loadImage("grave.gif");
  private static Image HILLA1 = Element.loadImage("hilla1.gif");
  private static Image HILLA2 = Element.loadImage("hilla2.gif");
  private static Image HILLB1 = Element.loadImage("hillb1.gif");
  private static Image HILLB2 = Element.loadImage("hillb2.gif");
  private static Image MOUNTAINA1 = Element.loadImage("mountaina1.gif");
  private static Image MOUNTAINA2 = Element.loadImage("mountaina2.gif");
  private static Image PLACE = Element.loadImage("place.gif");
  private static Image TOWN = Element.loadImage("town.gif");

  public WorldData()
  {
    super();
    loadDialogue();
    precacheObjects();
  }

  private void precacheObjects()
  {

      new BadEye(new Position(0, 0), 0, 0);
      new BiGhost(new Position(0, 0));
      new Bloob(new Position(0, 0));
      new Crystal(new Position(0, 0), 0);
      new CrystalGiver(new Position(0, 0), 0);
      new DownSpike(new Position(0, 0));
      new Folk(new Position(0, 0), 0);
      new Ghost(new Position(0, 0));
      new GreenTree(new Position(0, 0));
      new Healer(new Position(0, 0));
      new King(new Position(0, 0));
      new Player(new Position(0, 0));
      new Projectile(new Position(0, 0), 0, 0, 0, null);
      new RectangleObstacle(new Position(0, 0), 0, 0, null);
      new RedTree(new Position(0, 0));
      new SpikePit(new Position(0, 0), 0, 0, null);
      new Spiter(new Position(0, 0));
      new ToumbStone(new Position(0, 0));
      new UpSpike(new Position(0, 0));
      new YellowTree(new Position(0, 0));

  }

  private static void loadDialogue()
  {
    dialogue = new String[11][];

    dialogue[0] = new String[3];
      dialogue[0][0] = "Hello there, wary traveller.";
      dialogue[0][1] = "They say there's a blue crystal on the Ereal Plane.";
      dialogue[0][2] = "I heard it is directly south of here.";

    dialogue[1] = new String[3];
      dialogue[1][0] = "I am the healing goddess. I can heal you!";
      dialogue[1][1] = "There... Isn't that much better?";
      dialogue[1][2] = "Good luck!";


    dialogue[2] = new String[3];
      dialogue[2][0] = "I found a blue crystal... Here, you can have it!";
      dialogue[2][1] = "...";
      dialogue[2][2] = "You found a crystal!";

    dialogue[3] = new String[3];
      dialogue[3][0] = "I am a happy gardener!";
      dialogue[3][1] = "This stream nourishes the crop.";
      dialogue[3][2] = "It won't flow if the crystals are not collected...";

    dialogue[4] = new String[3];
      dialogue[4][0] = "We're twins.";
      dialogue[4][1] = "Can't you tell?";
      dialogue[4][2] = "We look exactly the same, don't we?";

    dialogue[5] = new String[1];
      dialogue[5][0] = "I'm a fair dwarf maiden...";

    dialogue[6] = new String[2];
      dialogue[6][0] = "There is a crystal on South Rock";
      dialogue[6][1] = "Ther's one just east of Albi Desert and some more in a desert cave.";

    dialogue[7] = new String[2];
      dialogue[7][0] = "Press CTRL to kill enemies with your spear.";
      dialogue[7][1] = "Something good happens when your score reaches 250, 500, 1000 and 2000";

    dialogue[8] = new String[2];
      dialogue[8][0] = "The only exit to this town is the door to the king's palace.";
      dialogue[8][1] = "Its on the west wall just above that red building.";

    dialogue[9] = new String[2];
      dialogue[9][0] = "There is a lonely old hermit who lives on the Ereal Hills";
      dialogue[9][1] = "I believe that he possesses one crystal.";

    dialogue[10] = new String[4];
      dialogue[10][0] = "There is a deep dark forest to the east called Dethenwood.";
      dialogue[10][1] = "We have an ancient grave yard deep within which contains a crystal.";
      dialogue[10][2] = "The forest is tricky to navigate. Just start when you enter";
      dialogue[10][3] = "and see a healer goddess and remember the word NESS...";
  }

  public static int getHealMessageIndex()
  {
    return 1;
  }

  public static int getGiveCrystalMessageIndex()
  {
    return 2;
  }

  public static String[] getDialogue(int index)
  {
    if (index >= 0 && index < dialogue.length)
      return dialogue[index];
    else
      return new String[0];
  }

  public static ArrayList loadWorld(int x, int y, Player you, Player2 friend)
  {
    System.out.println("Now entering area (" + x + ", " + y + ").");
    ArrayList temp = new ArrayList();
    temp.add(friend);
    temp.add(you);

    PlayAreaView.setBackgroundImage(null);

//The test level
    if (x ==
              0
    && y ==
              1)
    {
    changeSong(KING_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(THRONE);
    temp.add(new King(new Position(100,95)));
    temp.add(new Folk(new Position(120,95), 0));
    temp.add(new Healer(new Position(52,85)));
    temp.add(new RectangleObstacle(new Position(0,0), 200, 91, null));
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));
    temp.add(new RectangleObstacle(new Position(195,109), 5, 41, null));

    /*temp.add(new Crystal(new Position(89, 111), 0));
    temp.add(new Crystal(new Position(89, 111), 1));
    temp.add(new Crystal(new Position(80, 110), 2));
    temp.add(new Crystal(new Position(89, 111), 3));
    temp.add(new Crystal(new Position(89, 116), 4));
    temp.add(new Crystal(new Position(87, 110), 5));
    temp.add(new Crystal(new Position(89, 112), 6));
    temp.add(new Crystal(new Position(87, 120), 7));
    temp.add(new Crystal(new Position(79, 130), 8));
    temp.add(new Crystal(new Position(83, 111), 9));
    temp.add(new Crystal(new Position(83, 111), 10));
    temp.add(new Crystal(new Position(83, 111), 11));*/
    }

    else if (x ==
              0
    && y ==
              2)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTA1);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));
    temp.add(new RectangleObstacle(new Position(195,0), 5, 5, null));//grass hut

    temp.add(new Bloob(new Position(80, 75)));//introductory enemy in the centre
    temp.add(new Bloob(new Position(120, 75)));//introductory enemy in the centre

    }

    else if (x ==
              0
    && y ==
              3)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTA2);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));
    temp.add(new Bloob(new Position(100, 75)));//enemy in the centre of trees

    temp.add(new GreenTree(new Position(30, 20)));//three lovley little trees
    temp.add(new GreenTree(new Position(150, 60)));//three lovley little trees
    temp.add(new GreenTree(new Position(90, 110)));//three lovley little trees
    }

    else if (x ==
              0
    && y ==
              4)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTA3);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));

    temp.add(new Crystal(new Position(100, 75), 0));
    }

    else if (x ==
              0
    && y ==
              5)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTA4);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));

    temp.add(new Bloob(new Position(40, 45)));
    temp.add(new Ghost(new Position(100, 100), 7, 2.4, 20, Color.pink));

    }

    else if (x ==
              1
    && y ==
              1)
    {
    changeSong("file:sound/town.wav");
    PlayAreaView.setBackgroundImage(TOWN);

    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//north boundary
    temp.add(new RectangleObstacle(new Position(0,0), 5, 91, null));//west boundary
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary

    temp.add(new RectangleObstacle(new Position(0,109), 25, 41, null));//red hut boundary

    temp.add(new RectangleObstacle(new Position(0,0), 61, 64, null));//topleft huts

    temp.add(new RectangleObstacle(new Position(42,96), 43, 27, null));//red hut

    temp.add(new RectangleObstacle(new Position(122,64), 56, 31, null));//grass hut

    temp.add(new RectangleObstacle(new Position(85,28), 58, 35, null));//multi-door hut

    temp.add(new RectangleObstacle(new Position(149,19), 43, 26, null));//white house
    temp.add(new Folk(new Position(65, 13), 4));//twin folk blocking the way
    temp.add(new Folk(new Position(55, 26), 4));//twin folk blocking the way
    temp.add(new Folk(new Position(182, 136), 3));//a happy gardener

    temp.add(new Folk(new Position(5, 65), 9));//folk blocking the way
    temp.add(new Folk(new Position(40, 61), 5));//maiden blocking door to grass hut

    temp.add(new Folk(new Position(63, 122), 7));//folk blocking the door to brick hut

    temp.add(new Folk(new Position(172, 45), 10));//folk blocking the door to brick hut 2

    temp.add(new Folk(new Position(160, 95), 6));//folk blocking the door to grass hut 2

    temp.add(new Folk(new Position(100, 61), 8));//folk in centre of town
    }

    else if (x ==
              1
    && y ==
              2)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTB1);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));
    temp.add(new Ghost(new Position(122, 100), 7, 1.2, 40, Color.pink));
    temp.add(new Ghost(new Position(120, 110), 7, 1.2, 40, Color.pink));
    }

    else if (x ==
              1
    && y ==
              3)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTB2);

    temp.add(new Bloob(new Position(100, 40)));
    temp.add(new Bloob(new Position(50, 130)));
    temp.add(new Bloob(new Position(150, 130)));

    temp.add(new GreenTree(new Position(60, 50)));
    }

    else if (x ==
              1
    && y ==
              4)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTB3);
    temp.add(new Bloob(new Position(80, 75)));
    temp.add(new Bloob(new Position(40, 135)));
    temp.add(new Bloob(new Position(160, 55)));
    temp.add(new Bloob(new Position(110, 95)));
    temp.add(new Bloob(new Position(90, 85)));
    temp.add(new Bloob(new Position(130, 65)));
    temp.add(new Bloob(new Position(170, 125)));
    temp.add(new Bloob(new Position(30, 120)));
    }

    else if (x ==
              1
    && y ==
              5)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTB4);
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary

    temp.add(new Bloob(new Position(90, 85)));
    temp.add(new Bloob(new Position(130, 75)));

    temp.add(new GreenTree(new Position(70, 20)));
    temp.add(new GreenTree(new Position(72, 40)));
    temp.add(new GreenTree(new Position(74, 60)));
    temp.add(new GreenTree(new Position(69, 80)));

    temp.add(new Ghost(new Position(100, 100), 7, 2.4, 20, Color.pink));
    }

    else if (x ==
              2
    && y ==
              2)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTC1);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//north boundary

    temp.add(new Bloob(new Position(81, 72)));
    temp.add(new Bloob(new Position(43, 34)));
    temp.add(new Bloob(new Position(163, 53)));
    temp.add(new Bloob(new Position(82, 93)));
    temp.add(new Bloob(new Position(93, 82)));
    temp.add(new Bloob(new Position(133, 35)));
    temp.add(new Bloob(new Position(173, 124)));
    temp.add(new Bloob(new Position(34, 124)));
    temp.add(new Bloob(new Position(100, 77)));
    temp.add(new Bloob(new Position(114, 23)));
    temp.add(new Bloob(new Position(33, 35)));
    temp.add(new Bloob(new Position(93, 94)));
    temp.add(new Bloob(new Position(25, 134)));

    }

    else if (x ==
              2
    && y ==
              3)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTC2);
    temp.add(new Ghost(new Position(122, 100), 7, 2.4, 40, Color.pink));//ghost parade
    }

    else if (x ==
              2
    && y ==
              4)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTC3);
    temp.add(new Healer(new Position(95, 60)));
    }

    else if (x ==
              2
    && y ==
              5)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTC4);
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary

    temp.add(new Ghost(new Position(100, 40), 7, 2.4, 20, Color.pink));
    temp.add(new Ghost(new Position(100, 110), 7, 2.4, 20, Color.pink));
    }

    else if (x ==
              3
    && y ==
              0)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(MOUNTAINA1);

    temp.add(new RectangleObstacle(new Position(0,0), 200, 43, null));//dont go into sky

    temp.add(new RectangleObstacle(new Position(0,87), 77, 63, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,0), 20, 150, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,0), 45, 62, null));//dont go into mountains

    temp.add(new RectangleObstacle(new Position(113,132), 87, 18, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(107,116), 93, 16, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(94, 96), 106, 20, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(88,73), 101, 20, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(113,59), 15, 40, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(162,58), 25, 36, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(199,0), 1, 55, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(199,75), 1, 75, null));//dont go into mountains
    temp.add(new Guard(new Position(85, 95), 9));
    //one on mountain to show you the way
    temp.add(new Crystal(new Position(195, 65), 1));
    }

    else if (x ==
              3
    && y ==
              1)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(MOUNTAINA2);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));//west boundary

    temp.add(new RectangleObstacle(new Position(0,0), 50, 133, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,90), 75, 45, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,0), 50, 134, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,0), 69, 80, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(0,0), 90, 64, null));//dont go into mountains

    temp.add(new RectangleObstacle(new Position(118,51), 82, 19, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(163,0), 37, 51, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(133,0), 67, 19, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(104,70), 96, 30, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(148,100), 52, 24, null));//dont go into mountains
    temp.add(new RectangleObstacle(new Position(113,0), 87, 5, null));//dont go into mountains
    temp.add(new Bloob(new Position(140, 55)));
    temp.add(new Bloob(new Position(105, 110)));
    }

    else if (x ==
              3
    && y ==
              2)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTD1);
    temp.add(new RectangleObstacle(new Position(0,0), 5, 5, null));
    temp.add(new RectangleObstacle(new Position(195,137), 5, 13, null));//keep out of cave side!
    temp.add(new Ghost(new Position(120, 110), 6, 1.6, 25, Color.blue));//ghost
    temp.add(new Ghost(new Position(50, 110), 6, 1.6, 25, Color.blue));//ghost
    temp.add(new Ghost(new Position(40, 35), 21, .6, 15, Color.yellow));//ghost
    temp.add(new Ghost(new Position(140, 35), 21, .6, 15, Color.yellow));//ghost
    }

    else if (x ==
              3
    && y ==
              3)
    {
    changeSong(MAIN_THEME_LOCATION);
    PlayAreaView.setBackgroundImage(FORESTD2);
    temp.add(new RectangleObstacle(new Position(195,137), 5, 13, null));//keep out of cave side!

    temp.add(new Ghost(new Position(120, 110), 6, .6, 21, Color.yellow));//ghost parade
    temp.add(new Ghost(new Position(40, 20), 12, .6, 50, Color.cyan));//ghost parade
    temp.add(new Ghost(new Position(170, 140), 10, 1.2, 22, Color.green));//ghost parade
    temp.add(new Ghost(new Position(30, 135), 15, .9,80, Color.orange));//ghost parade
    temp.add(new Ghost(new Position(12, 100), 7, 2.4, 40, Color.pink));//ghost parade
    temp.add(new Ghost(new Position(100, 75), 6, .7, 25, Color.yellow));//ghost parade
    temp.add(new Ghost(new Position(40, 35), 12, 1.6, 15, Color.red));//ghost parade

    temp.add(new Crystal(new Position(100, 70), 11));

    temp.add(new GreenTree(new Position(110, 80)));
    temp.add(new GreenTree(new Position(175, 40)));
    temp.add(new GreenTree(new Position(90, 30)));
    temp.add(new GreenTree(new Position(30, 70)));
    temp.add(new GreenTree(new Position(35, 85)));
    temp.add(new YellowTree(new Position(170, 90)));
    temp.add(new YellowTree(new Position(100, 95)));
    temp.add(new YellowTree(new Position(10, 140)));
    }

    else if (x ==
              3
    && y ==
              4)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(FORESTD3);

    temp.add(new Bloob(new Position(20, 72)));
    temp.add(new Bloob(new Position(20, 122)));
    temp.add(new Bloob(new Position(81, 122)));
    temp.add(new Bloob(new Position(130, 138)));
    temp.add(new Bloob(new Position(172, 72)));
    temp.add(new Bloob(new Position(110, 72)));

    temp.add(new RedTree(new Position(30, 80)));
    temp.add(new RedTree(new Position(90, 83)));
    temp.add(new RedTree(new Position(170, 77)));
    }

    else if (x ==
              3
    && y ==
              5)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(FORESTD4);
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary
    temp.add(new RectangleObstacle(new Position(195, 0), 5, 150, null));//east boundary

    temp.add(new Ghost(new Position(40, 40), 7, 2.6, 20, Color.gray));
    temp.add(new Ghost(new Position(40, 110), 7, 2.6, 20, Color.gray));

    temp.add(new Ghost(new Position(160, 40), 7, 2.1, 20, Color.gray));
    temp.add(new Ghost(new Position(160, 110), 7, 2.1, 20, Color.gray));
    temp.add(new Ghost(new Position(100, 75), 7, 1.1, 20, Color.gray));

    temp.add(new Crystal(new Position(89, 111), 2));

    }


    else if (x ==
              4
    && y ==
              0)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(ENTRENCE);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 61, null));//dont go into sky
    temp.add(new RectangleObstacle(new Position(0,70), 200, 80, null));//dont go into mountains
    temp.add(new DownSpike(new Position(40,10)));
    temp.add(new DownSpike(new Position(100,10)));
    temp.add(new DownSpike(new Position(160,10)));
    }


    else if (x ==
              4
    && y ==
              1)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(HILLA1);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//north boundary
    temp.add(new RectangleObstacle(new Position(0,0), 5, 124, null));//west boundary

    temp.add(new Projectile(new Position(20, 10), .4, 6.6, 10, Color.lightGray));
    temp.add(new Projectile(new Position(65, 10), 0, 15.9, 12, Color.gray));
    temp.add(new Projectile(new Position(120, 10), -.1, 13.6, 8, Color.lightGray));
    temp.add(new Projectile(new Position(160, 10), -.6, 11.6, 11, Color.gray));
    }

    else if (x ==
              4
    && y ==
              2)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(HILLA2);
    }

    else if (x ==
              4
    && y ==
              3)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(DESERTA1);

    }

    else if (x ==
              4
    && y ==
              4)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(DESERTA2);
    temp.add(new RectangleObstacle(new Position(0,137), 89, 13, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(116,137), 84, 13, null));//keep out of cave side!


    temp.add(new Projectile(new Position(25, 20), 3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(195, 40), -2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(195, 60), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(25, 80), 1.9, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(195, 100), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(25, 120), 2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(195, 140), -3.5, 0, 4, Color.darkGray));

    }

    else if (x ==
              4
    && y ==
              5)
    {
    changeSong("file:sound/cave.wav");
    PlayAreaView.setBackgroundImage(CAVEA1);

    {//insert a spike pit
    temp.remove(you);
    temp.add(new SpikePit(new Position(160, 110), 40, 40, null));
    temp.add(you);
    }


    temp.add(new RectangleObstacle(new Position(0,0), 89, 26, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,0), 31, 150, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(116,0), 84, 30, null));//keep out of cave side!
    temp.add(new Bloob(new Position(100, 70)));

    }

    else if (x ==
              4
    && y ==
              6)
    {
    changeSong("file:sound/cave.wav");

    {//insert a spike pit
    temp.remove(you);
    temp.add(new SpikePit(new Position(160, 0), 40, 40, null));
    temp.add(you);
    }

    PlayAreaView.setBackgroundImage(CAVEA2);
    temp.add(new RectangleObstacle(new Position(0,0), 31, 150, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,100), 53, 50, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,126), 200, 24, null));//keep out of cave side!

    temp.add(new Spiter(new Position(120,115)));
    temp.add(new Crystal(new Position(100,115), 3));
    }

    else if (x ==
              5
    && y ==
              0)
    {
    changeSong("file:sound/castle.wav");
    PlayAreaView.setBackgroundImage(DUNGEONA1);
    temp.add(new RectangleObstacle(new Position(0,0), 11, 55, null));//keep out of dungeon walls
    temp.add(new RectangleObstacle(new Position(0,75), 11, 75, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,0), 200, 8, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,140), 200, 10, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,0), 200, 8, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(184,0), 11, 71, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(34,48), 124, 41, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(147,89), 11, 61, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(195,0), 5, 28, null));//keep out of cave side!

    temp.add(new Crystal(new Position(140, 110), 4));
    temp.add(new Bloob(new Position(130, 107)));
    temp.add(new Bloob(new Position(50, 117)));
    temp.add(new Bloob(new Position(100, 95)));
    temp.add(new Bloob(new Position(90, 50)));
    temp.add(new Bloob(new Position(175, 60)));

    temp.add(new Ghost(new Position(120, 110), 6, .6, 21, Color.white));//ghost parade
    temp.add(new Ghost(new Position(40, 20), 12, .6, 50, Color.gray));//ghost parade
    temp.add(new Ghost(new Position(170, 140), 10, 1.2, 22, Color.blue));//ghost parade
    temp.add(new Ghost(new Position(30, 135), 15, .9,80, Color.darkGray));//ghost parade
    temp.add(new Ghost(new Position(12, 100), 7, 2.4, 40, Color.cyan));//ghost parade
    temp.add(new Ghost(new Position(100, 75), 6, .7, 25, Color.black));//ghost parade
    temp.add(new Ghost(new Position(40, 35), 12, 1.6, 15, Color.gray));//ghost parade

    }


    else if (x ==
              5
    && y ==
              1)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(HILLB1);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//north boundary
    temp.add(new CrystalGiver(new Position(120, 70), 5));
    }

    else if (x ==
              5
    && y ==
              2)
    {
    changeSong("file:sound/mountain.wav");
    PlayAreaView.setBackgroundImage(HILLB2);
    }

    else if (x ==
              5
    && y ==
              3)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(DESERTB1);
    temp.add(new RectangleObstacle(new Position(195,0), 5, 5, null));//boundary
    temp.add(new RectangleObstacle(new Position(195,145), 5, 5, null));//east boundary

    temp.add(new Projectile(new Position(190, 25), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 45), -2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 65), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 85), -1.8, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 105), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 125), -2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 140), -3.5, 0, 4, Color.darkGray));

    }

    else if (x ==
              5
    && y ==
              4)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(DESERTB2);
    temp.add(new RectangleObstacle(new Position(0,137), 200, 13, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary

    temp.add(new Projectile(new Position(190, 25), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 45), -2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 65), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 85), -1.8, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 105), -3.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 125), -2.5, 0, 4, Color.darkGray));
    temp.add(new Projectile(new Position(190, 140), -3.5, 0, 4, Color.darkGray));

    }

    else if (x ==
              5
    && y ==
              5)
    {
    changeSong("file:sound/cave.wav");
    PlayAreaView.setBackgroundImage(CAVEB1);

    {//insert a spike pit
    temp.remove(you);
    temp.add(new SpikePit(new Position(0, 110), 40, 40, null));
    temp.add(you);
    }

    temp.add(new RectangleObstacle(new Position(179,0), 21, 150, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,0), 200, 30, null));//keep out of cave side!

    temp.add(new DownSpike(new Position(67,10)));
    temp.add(new UpSpike(new Position(67,140)));

    temp.add(new DownSpike(new Position(134,10)));
    temp.add(new UpSpike(new Position(134,140)));

    temp.add(new Crystal(new Position(134,80), 6));

    }

    else if (x ==
              5
    && y ==
              6)
    {
    changeSong("file:sound/cave.wav");
    PlayAreaView.setBackgroundImage(CAVEB2);

    {//insert a spike pit
    temp.remove(you);
    temp.add(new SpikePit(new Position(0, 0), 40, 40, null));
    temp.add(you);
    }

    temp.add(new RectangleObstacle(new Position(0,126), 200, 24, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(161,42), 39, 108, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(179,0), 21, 42, null));//keep out of cave side!
    temp.add(new BiGhost(new Position(100,80)));
    temp.add(new Crystal(new Position(160,120), 7));
    }

    else if (x ==
              6
    && y ==
              0)
    {
    changeSong("file:sound/castle.wav");
    PlayAreaView.setBackgroundImage(DUNGEONB1);
    temp.add(new RectangleObstacle(new Position(0,0), 111, 28, null));//keep out wall
    temp.add(new RectangleObstacle(new Position(0,139), 200, 11, null));//keep out wall
    temp.add(new RectangleObstacle(new Position(10,76), 16, 74, null));//keep out wall
    temp.add(new RectangleObstacle(new Position(65,0), 16, 109, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(111,0), 89, 7, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(135,29), 65, 29, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(135, 79), 65, 32, null));//keep out of cave side!

    temp.add(new Ghost(new Position(60, 75)));
    temp.add(new Ghost(new Position(100, 75)));

    temp.add(new UpSpike(new Position(40, 140)));
    temp.add(new DownSpike(new Position(40, 10)));
    }

    else if (x ==
              6
    && y ==
              1)
    {
    changeSong("file:sound/forest.wav");
    PlayAreaView.setBackgroundImage(FOREST);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//south boundary
    temp.add(new RedTree(new Position(192, 144)));
    temp.add(new RedTree(new Position(100, 73)));
    temp.add(new RedTree(new Position(50, 93)));
    //temp.add(new RedTree(new Position(175, 130)));

    temp.add(new RedTree(new Position(35, -4)));
    temp.add(new YellowTree(new Position(60, -5)));
    temp.add(new YellowTree(new Position(73, -1)));

    temp.add(new GreenTree(new Position(70, 20)));
    temp.add(new YellowTree(new Position(0, -7)));
    temp.add(new RedTree(new Position(101, 7)));
    temp.add(new RedTree(new Position(45, 19)));

    temp.add(new RedTree(new Position(55, 32)));
    temp.add(new YellowTree(new Position(75, 49)));
    temp.add(new YellowTree(new Position(34, 50)));

    temp.add(new GreenTree(new Position(70, 125)));
    temp.add(new YellowTree(new Position(20, 130)));
    temp.add(new GreenTree(new Position(90, 115)));
    temp.add(new GreenTree(new Position(170, 140)));
    temp.add(new GreenTree(new Position(40, 100)));


    temp.add(new YellowTree(new Position(120, 30)));
    temp.add(new GreenTree(new Position(150, 115)));
    temp.add(new GreenTree(new Position(190, 40)));
    temp.add(new RedTree(new Position(170, 80)));

    temp.add(new GreenTree(new Position(0, 110)));
    temp.add(new RedTree(new Position(185, 10)));
    }

    else if (x ==
              6
    && y ==
              2)
    {
    changeSong("file:sound/forest.wav");
    PlayAreaView.setBackgroundImage(FOREST);
    temp.add(new RectangleObstacle(new Position(195, 0), 5, 150, null));//south boundary
    temp.add(new RedTree(new Position(50, 93)));
    temp.add(new RedTree(new Position(175, 130)));

    temp.add(new GreenTree(new Position(70, 20)));
    temp.add(new RedTree(new Position(101, 7)));
    temp.add(new RedTree(new Position(45, 19)));

    temp.add(new RedTree(new Position(55, 32)));
    temp.add(new YellowTree(new Position(75, 49)));
    temp.add(new YellowTree(new Position(34, 50)));

    temp.add(new GreenTree(new Position(70, 125)));
    temp.add(new YellowTree(new Position(20, 130)));
    temp.add(new GreenTree(new Position(90, 115)));
    temp.add(new GreenTree(new Position(170, 140)));
    temp.add(new GreenTree(new Position(40, 100)));


    temp.add(new YellowTree(new Position(120, 30)));
    temp.add(new GreenTree(new Position(150, 115)));
    temp.add(new GreenTree(new Position(190, 40)));
    temp.add(new RedTree(new Position(170, 80)));

    temp.add(new GreenTree(new Position(0, 110)));
    temp.add(new RedTree(new Position(185, 10)));
    temp.add(new Healer(new Position(159,25)));
    }

    else if (x ==
              6
    && y ==
              3)
    {
    changeSong("file:sound/desert.wav");
    PlayAreaView.setBackgroundImage(PLACE);
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary
    temp.add(new Crystal(new Position(100, 75), 8));
    }

    else if (x ==
              7
    && y ==
              0)
    {
    changeSong("file:sound/castle.wav");
    PlayAreaView.setBackgroundImage(DUNGEONC1);
    temp.add(new RectangleObstacle(new Position(0,0), 110, 7, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,29), 76, 29, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0, 79), 76, 32, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,139), 200, 11, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(59,29), 17, 82, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(110,0), 90, 42, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(65,61), 91, 31, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(141,61), 15, 89, null));//keep out of cave side!

    temp.add(new RectangleObstacle(new Position(189,0), 11, 57, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(189,79), 11, 71, null));//keep out of cave side!

    temp.add(new Guard(new Position(140,55),12));
    temp.add(new Healer(new Position(115, 108)));
    temp.add(new Bloob(new Position(25, 70)));
    temp.add(new Crystal(new Position(48, 70), 9));

    }

    else if (x ==
              7
    && y ==
              1)
    {
    changeSong("file:sound/forest.wav");
    PlayAreaView.setBackgroundImage(FOREST);
    temp.add(new RectangleObstacle(new Position(0,0), 200, 5, null));//north boundary
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary
    temp.add(new YellowTree(new Position(3, 145)));
    temp.add(new RedTree(new Position(50, 93)));
    temp.add(new RedTree(new Position(175, 130)));

    temp.add(new RedTree(new Position(35, -4)));
    temp.add(new YellowTree(new Position(60, -5)));
    temp.add(new YellowTree(new Position(73, -1)));

    temp.add(new GreenTree(new Position(70, 20)));
    temp.add(new YellowTree(new Position(0, -7)));
    temp.add(new RedTree(new Position(101, 7)));
    temp.add(new RedTree(new Position(45, 19)));

    temp.add(new RedTree(new Position(55, 32)));
    temp.add(new YellowTree(new Position(75, 49)));
    temp.add(new YellowTree(new Position(34, 50)));

    temp.add(new GreenTree(new Position(70, 125)));
    temp.add(new YellowTree(new Position(20, 130)));
    temp.add(new GreenTree(new Position(90, 115)));
    temp.add(new GreenTree(new Position(170, 140)));
    temp.add(new GreenTree(new Position(40, 100)));


    temp.add(new YellowTree(new Position(120, 30)));
    temp.add(new GreenTree(new Position(150, 115)));
    temp.add(new GreenTree(new Position(190, 40)));
    temp.add(new RedTree(new Position(170, 80)));

    temp.add(new GreenTree(new Position(0, 110)));
    temp.add(new RedTree(new Position(185, 10)));
    }

    else if (x ==
              7
    && y ==
              2)
    {
    changeSong("file:sound/forest.wav");
    PlayAreaView.setBackgroundImage(FOREST);
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));//west boundary
    temp.add(new RedTree(new Position(50, 93)));
    temp.add(new RedTree(new Position(175, 130)));


    temp.add(new GreenTree(new Position(70, 20)));
    temp.add(new RedTree(new Position(101, 7)));
    temp.add(new RedTree(new Position(45, 19)));

    temp.add(new RedTree(new Position(55, 32)));
    temp.add(new YellowTree(new Position(75, 49)));
    temp.add(new YellowTree(new Position(34, 50)));

    temp.add(new GreenTree(new Position(70, 125)));
    temp.add(new YellowTree(new Position(20, 130)));
    temp.add(new GreenTree(new Position(90, 115)));
    temp.add(new GreenTree(new Position(170, 140)));
    temp.add(new GreenTree(new Position(40, 100)));


    temp.add(new YellowTree(new Position(120, 30)));
    temp.add(new GreenTree(new Position(150, 115)));
    temp.add(new GreenTree(new Position(190, 40)));
    temp.add(new RedTree(new Position(170, 80)));

    temp.add(new GreenTree(new Position(0, 110)));
    temp.add(new RedTree(new Position(185, 10)));
    }

    else if (x ==
              7
    && y ==
              3)
    {
    changeSong("file:sound/grave.wav");
    PlayAreaView.setBackgroundImage(GRAVE);
    temp.add(new RectangleObstacle(new Position(0,145), 200, 5, null));//south boundary
    temp.add(new RectangleObstacle(new Position(195,0), 5, 150, null));//east boundary
    temp.add(new RectangleObstacle(new Position(0,0), 5, 150, null));//west boundary
    temp.add(new Ghost(new Position (100, 80)));
    temp.add(new Spiter(new Position(100, 75)));
    temp.add(new Crystal(new Position(190, 140), 10));
    }

    else if (x ==
              8
    && y ==
              0)
    {
    changeSong("file:sound/boss.wav");
    PlayAreaView.setBackgroundImage(BOSS);
    temp.add(new RectangleObstacle(new Position(0,0), 15, 57, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,79), 15, 71, null));//keep out of cave side!

    temp.add(new RectangleObstacle(new Position(0,0), 200, 8, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(0,134), 200, 16, null));//keep out of cave side!
    temp.add(new RectangleObstacle(new Position(180,0), 20, 150, null));//keep out of cave side!

    temp.add(new BadEye(new Position(160, 70), 12, 8));

    temp.add(new Spiter(new Position(16,9)));
    temp.add(new Spiter(new Position(16,133)));

    temp.add(new Spiter(new Position(179,9)));
    temp.add(new Spiter(new Position(179,133)));

    temp.add(new Ghost(new Position(30, 30), 6, 1.2, 60, Color.gray));
    temp.add(new Ghost(new Position(33, 34), 6, .5, 60, Color.gray));

    temp.add(new Ghost(new Position(160, 30), 6, 1.2, 60, Color.gray));
    temp.add(new Ghost(new Position(163, 34), 6, .5, 60, Color.gray));

    temp.add(new Ghost(new Position(30, 130), 6, 1.2, 60, Color.gray));
    temp.add(new Ghost(new Position(33, 134), 6, .5, 60, Color.gray));

    temp.add(new Ghost(new Position(130, 130), 6, 1.2, 60, Color.gray));
    temp.add(new Ghost(new Position(133, 134), 6, .5, 60, Color.gray));


    }

    return temp;
  }


  public static void changeSong(String newSong)
  {
    if (!CURRENT_SONG_LOACTION.equals(newSong)) //Its not yet playing so we must now switch to new song
    {
      if (song != null)
        stopSong(); //Stop the old one if its playing
      song = Element.loadAudioClip(newSong);
      CURRENT_SONG_LOACTION = newSong;
      if (song != null)
        song.loop();
    }
  }

  public static void playSong(String newSong)
  {
    if (!CURRENT_SONG_LOACTION.equals(newSong)) //Its not yet playing so we must now switch to new song
    {
      if (song != null)
        stopSong(); //Stop the old one if its playing
      song = Element.loadAudioClip(newSong);
      CURRENT_SONG_LOACTION = newSong;
      if (song != null)
        song.play();
    }
  }

  public static void stopSong()
  {
    if (song != null)
      song.stop();
  }



}
