/*
 * Decompiled with CFR 0.152.
 */
package marauroa.client.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Locale;
import marauroa.common.i18n.I18N;

public class HTTPConnectSocket
extends Socket {
    private SocketAddress proxy = null;
    private static final int TIMEOUT = 60;
    private static final String HTTP_PREFIX = "HTTP/1.0 xxx";
    private static final byte[] HTTP_SUFFIX = new byte[]{13, 10, 13, 10};

    public HTTPConnectSocket(SocketAddress socketAddress) {
        this.proxy = socketAddress;
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        super.connect(this.proxy, n);
        this.setupHttpConnect(socketAddress);
    }

    private void setupHttpConnect(SocketAddress socketAddress) throws IOException {
        this.sendConnect(socketAddress);
        this.verifyConnection();
    }

    private void sendConnect(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IOException("Unkown endpoint object. Exspected InetSocketAddress but got " + socketAddress.getClass());
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        OutputStream outputStream = super.getOutputStream();
        StringBuilder stringBuilder = new StringBuilder("CONNECT ");
        stringBuilder.append(inetSocketAddress.getHostName());
        stringBuilder.append(":");
        stringBuilder.append(inetSocketAddress.getPort());
        stringBuilder.append(" HTTP/1.1\r\n");
        stringBuilder.append("Accept: text/plain,text/html;q=0.9,*/*;q=0.5\r\n");
        stringBuilder.append("\r\n");
        outputStream.write(stringBuilder.toString().getBytes("UTF-8"));
    }

    private void verifyConnection() throws IOException {
        byte[] byArray;
        InputStream inputStream = super.getInputStream();
        if (inputStream.read(byArray = new byte[HTTP_PREFIX.length()]) < byArray.length) {
            throw new IOException(I18N.translate("Unexpected end of stream while reading proxy answer.", new Object[0]));
        }
        String string = new String(byArray, "US-ASCII").toUpperCase(Locale.ENGLISH);
        if (!string.startsWith("HTTP/")) {
            byArray = new byte[4096];
            int n = inputStream.read(byArray);
            String string2 = string + new String(byArray, 0, n, "US-ASCII");
            throw new IOException(I18N.translate("Proxy connection failed. It does not seem to be a valid http-proxy because this response is unexpected: %1%s", string2));
        }
        if (!string.endsWith(" 200")) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
            String string3 = string.substring(string.length() - 3) + bufferedReader.readLine();
            bufferedReader.close();
            throw new IOException(I18N.translate("Proxy connection failed: %1$s", string3));
        }
        long l = System.currentTimeMillis();
        int n = 0;
        while (l + 60000L > System.currentTimeMillis()) {
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException(I18N.translate("Unexpected end of stream while reading proxy preload.", new Object[0]));
            }
            n = n2 == HTTP_SUFFIX[n] ? ++n : 0;
            if (n != HTTP_SUFFIX.length) continue;
            return;
        }
        throw new IOException(I18N.translate("Timeout while reading proxy preload", new Object[0]));
    }
}

