/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import marauroa.common.Logger;
import org.apache.log4j.PropertyConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4J {
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String DEFAULT_PROPERTIES = "log4j.rootLogger=INFO, Console\nlog4j.appender.Console=org.apache.log4j.ConsoleAppender\nlog4j.appender.Console.layout=org.apache.log4j.PatternLayout\nlog4j.appender.Console.threshold=INFO\nlog4j.appender.Console.layout.ConversionPattern=%-4r [%t] %-5p %c %x - %m%n\n";
    private static boolean configured = false;

    public static void init() {
        Log4J.init(LOG4J_PROPERTIES);
    }

    public static void init(String string) {
        if (configured) {
            return;
        }
        InputStream inputStream = Log4J.class.getClassLoader().getResourceAsStream(string);
        try {
            Properties properties = new Properties();
            if (inputStream == null) {
                System.err.println("Cannot find " + string + " in classpath. Using default properties.");
                properties.load(new ByteArrayInputStream(DEFAULT_PROPERTIES.getBytes("UTF-8")));
            } else {
                System.out.println("Configuring Log4J using " + string);
                properties.load(inputStream);
            }
            PropertyConfigurator.configure((Properties)properties);
            configured = true;
        }
        catch (IOException iOException) {
            System.err.println("cannot read property-file log4j.properties because " + iOException.getMessage());
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }
}

