/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common;

import marauroa.common.Log4J;
import marauroa.common.Logger;

public class MarauroaUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static Logger logger = Log4J.getLogger(MarauroaUncaughtExceptionHandler.class);
    private Thread.UncaughtExceptionHandler next;
    private boolean killOnError = false;

    public MarauroaUncaughtExceptionHandler(boolean bl) {
        this.killOnError = bl;
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.error("Exception in thread " + thread.getName(), throwable);
        System.err.println("Exception in thread " + thread.getName());
        throwable.printStackTrace();
        if (this.next != null) {
            this.next.uncaughtException(thread, throwable);
        }
        if (this.killOnError) {
            System.exit(1);
        }
    }

    public static void setup(boolean bl) {
        MarauroaUncaughtExceptionHandler marauroaUncaughtExceptionHandler = new MarauroaUncaughtExceptionHandler(bl);
        marauroaUncaughtExceptionHandler.next = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(marauroaUncaughtExceptionHandler);
    }
}

