/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import marauroa.common.game.Attributes;
import marauroa.common.game.DetailLevel;
import marauroa.common.net.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputSerializer {
    private final OutputStream out;
    private int protocolVersion = 35;

    public OutputSerializer(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(Serializable serializable) throws IOException {
        serializable.writeObject(this);
    }

    public void write(byte by) throws IOException {
        this.out.write(by);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray.length);
        this.out.write(byArray);
    }

    public void write255LongArray(byte[] byArray) throws IOException {
        if (byArray.length > 255) {
            throw new IOException("Array too large for write255LongArray.");
        }
        this.write((byte)byArray.length);
        this.out.write(byArray);
    }

    public void write65536LongArray(byte[] byArray) throws IOException {
        if (byArray.length > Short.MAX_VALUE) {
            throw new IOException();
        }
        this.write((short)byArray.length);
        this.out.write(byArray);
    }

    public void write(short s) throws IOException {
        byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
        this.out.write(byArray, 0, 2);
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >>> 24)};
        this.out.write(byArray);
    }

    public void write(long l) throws IOException {
        byte[] byArray = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >>> 56)};
        this.out.write(byArray);
    }

    public void write(float f) throws IOException {
        int n = Float.floatToIntBits(f);
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >>> 24)};
        this.out.write(byArray);
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes("UTF-8"));
    }

    public void write255LongString(String string) throws IOException {
        this.write255LongArray(string.getBytes("UTF-8"));
    }

    public void write65536LongString(String string) throws IOException {
        this.write65536LongArray(string.getBytes("UTF-8"));
    }

    public void write(String[] stringArray) throws IOException {
        this.write(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.write(stringArray[i]);
        }
    }

    public void write(Serializable[] serializableArray) throws IOException {
        this.write(serializableArray.length);
        for (int i = 0; i < serializableArray.length; ++i) {
            this.write(serializableArray[i]);
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public static void writeJson(StringBuilder stringBuilder, String string) {
        stringBuilder.append("\"");
        stringBuilder.append(string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n").replace("<", "\\u003c"));
        stringBuilder.append("\"");
    }

    public static void writeJson(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("\"");
        stringBuilder.append(string.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n").replace("<", "\\u003c"));
        stringBuilder.append("\":\"");
        stringBuilder.append(string2.replace("\\", "\\\\").replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n").replace("<", "\\u003c"));
        stringBuilder.append("\"");
    }

    public static void writeObjectCollectionToJson(StringBuilder stringBuilder, String string, Collection<? extends Attributes> collection, DetailLevel detailLevel) {
        stringBuilder.append(",\"");
        stringBuilder.append(string);
        stringBuilder.append("\":[");
        boolean bl = true;
        for (Attributes attributes : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("{");
            attributes.writeToJson(stringBuilder, detailLevel);
            stringBuilder.append("}");
        }
        stringBuilder.append("]");
    }
}

