/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.Map;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageC2SCreateCharacter
extends Message {
    private String character;
    private RPObject template;

    public MessageC2SCreateCharacter() {
        super(Message.MessageType.C2S_CREATECHARACTER, null);
    }

    public MessageC2SCreateCharacter(Channel channel, String string, RPObject rPObject) {
        super(Message.MessageType.C2S_CREATECHARACTER, channel);
        this.character = string;
        this.template = rPObject;
    }

    public String getCharacter() {
        return this.character;
    }

    public RPObject getTemplate() {
        return this.template;
    }

    @Override
    public String toString() {
        return "Message (C2S CreateCharacter) from (" + this.getAddress() + ") CONTENTS: (" + this.character + ";" + this.template + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.character);
        outputSerializer.write(this.template);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.character = inputSerializer.readString();
        this.template = (RPObject)inputSerializer.readObject(new RPObject());
        if (this.type != Message.MessageType.C2S_CREATECHARACTER) {
            throw new IOException();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        this.character = (String)map.get("charname");
        this.template = new RPObject();
        this.template.readFromMap((Map)map.get("template"));
        if (this.type != Message.MessageType.C2S_CREATECHARACTER) {
            throw new IOException();
        }
    }
}

