/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.Locale;
import marauroa.common.crypto.Hash;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageSendByteArray;

public class MessageC2SLoginSendPromise
extends MessageSendByteArray {
    private String language = Locale.ENGLISH.getLanguage();

    public MessageC2SLoginSendPromise() {
        super(Message.MessageType.C2S_LOGIN_SENDPROMISE);
    }

    public MessageC2SLoginSendPromise(Channel channel, byte[] byArray, String string) {
        super(Message.MessageType.C2S_LOGIN_SENDPROMISE, channel, byArray);
        this.language = string;
    }

    public String getLanguage() {
        return this.language;
    }

    public String toString() {
        return "Message (C2S Login Send Promise) from (" + this.getAddress() + ") CONTENTS: (hash: " + Hash.toHexString(this.hash) + " language: " + this.language + ")";
    }

    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        if (inputSerializer.available() > 0) {
            this.language = inputSerializer.read255LongString();
        }
        if (this.type != Message.MessageType.C2S_LOGIN_SENDPROMISE) {
            throw new IOException();
        }
    }

    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write255LongString(this.language);
    }
}

