/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Utility;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.IRPZone;
import marauroa.common.game.Perception;
import marauroa.common.game.RPObject;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import org.apache.log4j.NDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageS2CPerception
extends Message {
    static final Logger logger = Log4J.getLogger(MessageS2CPerception.class);
    byte typePerception;
    private int timestampPerception;
    IRPZone.ID zoneid;
    private List<RPObject> addedRPObjects;
    private List<RPObject> modifiedAddedAttribsRPObjects;
    private List<RPObject> modifiedDeletedAttribsRPObjects;
    private List<RPObject> deletedRPObjects;
    private RPObject myRPObjectModifiedAdded;
    private RPObject myRPObjectModifiedDeleted;
    private static CachedCompressedPerception cache = CachedCompressedPerception.get();

    public MessageS2CPerception() {
        super(Message.MessageType.S2C_PERCEPTION, null);
    }

    public MessageS2CPerception(Channel channel, Perception perception) {
        super(Message.MessageType.S2C_PERCEPTION, channel);
        this.typePerception = perception.type;
        this.zoneid = perception.zoneid;
        this.addedRPObjects = perception.addedList;
        this.modifiedAddedAttribsRPObjects = perception.modifiedAddedList;
        this.modifiedDeletedAttribsRPObjects = perception.modifiedDeletedList;
        this.deletedRPObjects = perception.deletedList;
    }

    public void setMyRPObject(RPObject rPObject, RPObject rPObject2) {
        this.myRPObjectModifiedAdded = rPObject;
        this.myRPObjectModifiedDeleted = rPObject2;
    }

    public RPObject getMyRPObjectAdded() {
        return this.myRPObjectModifiedAdded;
    }

    public RPObject getMyRPObjectDeleted() {
        return this.myRPObjectModifiedDeleted;
    }

    public void setPerceptionTimestamp(int n) {
        this.timestampPerception = n;
    }

    public int getPerceptionTimestamp() {
        return this.timestampPerception;
    }

    public byte getPerceptionType() {
        return this.typePerception;
    }

    public IRPZone.ID getRPZoneID() {
        return this.zoneid;
    }

    public List<RPObject> getAddedRPObjects() {
        return this.addedRPObjects;
    }

    public List<RPObject> getModifiedAddedRPObjects() {
        return this.modifiedAddedAttribsRPObjects;
    }

    public List<RPObject> getModifiedDeletedRPObjects() {
        return this.modifiedDeletedAttribsRPObjects;
    }

    public List<RPObject> getDeletedRPObjects() {
        return this.deletedRPObjects;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Type: " + this.typePerception + " Timestamp: " + this.timestampPerception + ") contents: ");
        stringBuilder.append("\n  zoneid: " + this.zoneid + "\n");
        stringBuilder.append("\n  added: \n");
        for (RPObject rPObject : this.addedRPObjects) {
            stringBuilder.append("    " + rPObject + "\n");
        }
        stringBuilder.append("\n  modified added: \n");
        for (RPObject rPObject : this.modifiedAddedAttribsRPObjects) {
            stringBuilder.append("    " + rPObject + "\n");
        }
        stringBuilder.append("\n  modified deleted: \n");
        for (RPObject rPObject : this.modifiedDeletedAttribsRPObjects) {
            stringBuilder.append("    " + rPObject + "\n");
        }
        stringBuilder.append("\n  deleted: \n");
        for (RPObject rPObject : this.deletedRPObjects) {
            stringBuilder.append("    " + rPObject + "\n");
        }
        stringBuilder.append("\n  my object modified added: \n");
        stringBuilder.append("    " + this.myRPObjectModifiedAdded + "\n");
        stringBuilder.append("\n  my object modified deleted: \n");
        stringBuilder.append("    " + this.myRPObjectModifiedDeleted + "\n");
        return stringBuilder.toString();
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writing Object: [" + this + "]");
        }
        super.writeObject(outputSerializer);
        outputSerializer.write(this.getPrecomputedStaticPartPerception());
        outputSerializer.write(this.getDynamicPartPerception(outputSerializer.getProtocolVersion()));
    }

    private void setZoneid(RPObject rPObject, String string) {
        rPObject.put("zoneid", string);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        int n;
        int n2;
        super.readObject(inputSerializer);
        byte[] byArray = inputSerializer.readByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream, new Inflater());
        InputSerializer inputSerializer2 = new InputSerializer(inflaterInputStream);
        inputSerializer2.setProtocolVersion(this.protocolVersion);
        try {
            int n3;
            int n4;
            this.typePerception = inputSerializer2.readByte();
            this.zoneid = (IRPZone.ID)inputSerializer2.readObject(new IRPZone.ID(""));
            this.addedRPObjects = new LinkedList<RPObject>();
            this.deletedRPObjects = new LinkedList<RPObject>();
            this.modifiedAddedAttribsRPObjects = new LinkedList<RPObject>();
            this.modifiedDeletedAttribsRPObjects = new LinkedList<RPObject>();
            n2 = inputSerializer2.readInt();
            if (n2 > 262144) {
                throw new IOException("Illegal request of an list of " + String.valueOf(n2) + " size");
            }
            logger.debug(n2 + " added objects.");
            for (n = 0; n < n2; ++n) {
                RPObject rPObject = (RPObject)inputSerializer2.readObject(new RPObject());
                this.setZoneid(rPObject, this.zoneid.getID());
                this.addedRPObjects.add(rPObject);
            }
            n = inputSerializer2.readInt();
            if (n > 262144) {
                throw new IOException("Illegal request of an list of " + String.valueOf(n) + " size");
            }
            logger.debug(n + " modified Added objects..");
            for (n4 = 0; n4 < n; ++n4) {
                RPObject rPObject = (RPObject)inputSerializer2.readObject(new RPObject());
                this.setZoneid(rPObject, this.zoneid.getID());
                this.modifiedAddedAttribsRPObjects.add(rPObject);
            }
            n4 = inputSerializer2.readInt();
            if (n4 > 262144) {
                throw new IOException("Illegal request of an list of " + String.valueOf(n4) + " size");
            }
            logger.debug(n4 + " modified Deleted objects..");
            for (n3 = 0; n3 < n4; ++n3) {
                RPObject rPObject = (RPObject)inputSerializer2.readObject(new RPObject());
                this.setZoneid(rPObject, this.zoneid.getID());
                this.modifiedDeletedAttribsRPObjects.add(rPObject);
            }
            n3 = inputSerializer2.readInt();
            if (n3 > 262144) {
                throw new IOException("Illegal request of an list of " + String.valueOf(n3) + " size");
            }
            logger.debug(n3 + " deleted objects..");
            for (int i = 0; i < n3; ++i) {
                RPObject rPObject = (RPObject)inputSerializer2.readObject(new RPObject());
                this.setZoneid(rPObject, this.zoneid.getID());
                this.deletedRPObjects.add(rPObject);
            }
        }
        catch (IOException iOException) {
            InflaterInputStream inflaterInputStream2 = new InflaterInputStream(new ByteArrayInputStream(byArray), new Inflater());
            NDC.push((String)("message is [" + this + "]\n"));
            NDC.push((String)("message dump is [\n" + Utility.dumpInputStream(inflaterInputStream2) + "\n]\n"));
            logger.error("error in getMessage", iOException);
            NDC.pop();
            NDC.pop();
            return;
        }
        byteArrayInputStream = new ByteArrayInputStream(inputSerializer.readByteArray());
        inputSerializer2 = new InputSerializer(byteArrayInputStream);
        inputSerializer2.setProtocolVersion(this.protocolVersion);
        this.timestampPerception = inputSerializer2.readInt();
        logger.debug("read My RPObject");
        n2 = inputSerializer2.readByte();
        if (n2 == 1) {
            this.myRPObjectModifiedAdded = (RPObject)inputSerializer2.readObject(new RPObject());
            this.setZoneid(this.myRPObjectModifiedAdded, this.zoneid.getID());
        } else {
            this.myRPObjectModifiedAdded = null;
        }
        n = inputSerializer2.readByte();
        if (n == 1) {
            this.myRPObjectModifiedDeleted = (RPObject)inputSerializer2.readObject(new RPObject());
            this.setZoneid(this.myRPObjectModifiedDeleted, this.zoneid.getID());
        } else {
            this.myRPObjectModifiedDeleted = null;
        }
    }

    public static void clearPrecomputedPerception() {
        cache.clear();
    }

    private byte[] getPrecomputedStaticPartPerception() throws IOException {
        return cache.get(this);
    }

    private byte[] getDynamicPartPerception(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputSerializer outputSerializer = new OutputSerializer(byteArrayOutputStream);
        outputSerializer.setProtocolVersion(n);
        outputSerializer.write(this.timestampPerception);
        if (this.myRPObjectModifiedAdded == null) {
            outputSerializer.write((byte)0);
        } else {
            outputSerializer.write((byte)1);
            this.myRPObjectModifiedAdded.writeObject(outputSerializer, DetailLevel.PRIVATE);
        }
        if (this.myRPObjectModifiedDeleted == null) {
            outputSerializer.write((byte)0);
        } else {
            outputSerializer.write((byte)1);
            this.myRPObjectModifiedDeleted.writeObject(outputSerializer, DetailLevel.PRIVATE);
        }
        return byteArrayOutputStream.toByteArray();
    }

    void computeStaticPartPerception(OutputSerializer outputSerializer) throws IOException {
        outputSerializer.write(this.typePerception);
        outputSerializer.write(this.zoneid);
        outputSerializer.write(this.addedRPObjects.size());
        for (RPObject rPObject : this.addedRPObjects) {
            outputSerializer.write(rPObject);
        }
        outputSerializer.write(this.modifiedAddedAttribsRPObjects.size());
        for (RPObject rPObject : this.modifiedAddedAttribsRPObjects) {
            outputSerializer.write(rPObject);
        }
        outputSerializer.write(this.modifiedDeletedAttribsRPObjects.size());
        for (RPObject rPObject : this.modifiedDeletedAttribsRPObjects) {
            outputSerializer.write(rPObject);
        }
        outputSerializer.write(this.deletedRPObjects.size());
        for (RPObject rPObject : this.deletedRPObjects) {
            outputSerializer.write(rPObject);
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "zoneid", this.zoneid.getID());
        stringBuilder.append(",");
        OutputSerializer.writeJson(stringBuilder, "sync");
        stringBuilder.append(":");
        if (this.typePerception == 1) {
            stringBuilder.append("true");
        } else {
            stringBuilder.append("false");
        }
        if (this.addedRPObjects != null && !this.addedRPObjects.isEmpty()) {
            OutputSerializer.writeObjectCollectionToJson(stringBuilder, "aO", this.addedRPObjects, DetailLevel.NORMAL);
        }
        if (this.modifiedAddedAttribsRPObjects != null && !this.modifiedAddedAttribsRPObjects.isEmpty()) {
            OutputSerializer.writeObjectCollectionToJson(stringBuilder, "aA", this.modifiedAddedAttribsRPObjects, DetailLevel.NORMAL);
        }
        if (this.modifiedDeletedAttribsRPObjects != null && !this.modifiedDeletedAttribsRPObjects.isEmpty()) {
            OutputSerializer.writeObjectCollectionToJson(stringBuilder, "dA", this.modifiedDeletedAttribsRPObjects, DetailLevel.NORMAL);
        }
        if (this.deletedRPObjects != null && !this.deletedRPObjects.isEmpty()) {
            OutputSerializer.writeObjectCollectionToJson(stringBuilder, "dO", this.deletedRPObjects, DetailLevel.NORMAL);
        }
        if (this.myRPObjectModifiedAdded != null) {
            stringBuilder.append(",\"aM\":{");
            this.myRPObjectModifiedAdded.writeToJson(stringBuilder, DetailLevel.PRIVATE);
            stringBuilder.append("}");
        }
        if (this.myRPObjectModifiedDeleted != null) {
            stringBuilder.append(",\"dM\":{");
            this.myRPObjectModifiedDeleted.writeToJson(stringBuilder, DetailLevel.PRIVATE);
            stringBuilder.append("}");
        }
    }

    @Override
    public boolean isSkippable() {
        if (this.addedRPObjects != null && !this.addedRPObjects.isEmpty()) {
            return false;
        }
        if (this.modifiedAddedAttribsRPObjects != null && !this.modifiedAddedAttribsRPObjects.isEmpty()) {
            return false;
        }
        if (this.modifiedDeletedAttribsRPObjects != null && !this.modifiedDeletedAttribsRPObjects.isEmpty()) {
            return false;
        }
        if (this.deletedRPObjects != null && !this.deletedRPObjects.isEmpty()) {
            return false;
        }
        if (this.myRPObjectModifiedAdded != null) {
            return false;
        }
        return this.myRPObjectModifiedDeleted == null;
    }

    @Override
    public boolean isPerception() {
        return true;
    }

    static class CachedCompressedPerception {
        private final Map<CacheKey, byte[]> cachedContent = new HashMap<CacheKey, byte[]>();
        static CachedCompressedPerception instance;

        private CachedCompressedPerception() {
        }

        public static synchronized CachedCompressedPerception get() {
            if (instance == null) {
                instance = new CachedCompressedPerception();
            }
            return instance;
        }

        public synchronized void clear() {
            this.cachedContent.clear();
        }

        public synchronized byte[] get(MessageS2CPerception messageS2CPerception) throws IOException {
            CacheKey cacheKey = new CacheKey(messageS2CPerception.typePerception, messageS2CPerception.zoneid, messageS2CPerception.protocolVersion);
            if (!this.cachedContent.containsKey(cacheKey)) {
                logger.debug("Perception not found in cache");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                OutputSerializer outputSerializer = new OutputSerializer(deflaterOutputStream);
                outputSerializer.setProtocolVersion(messageS2CPerception.getProtocolVersion());
                messageS2CPerception.computeStaticPartPerception(outputSerializer);
                deflaterOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.cachedContent.put(cacheKey, byArray);
            } else {
                logger.debug("Perception FOUND in cache");
            }
            return this.cachedContent.get(cacheKey);
        }

        static class CacheKey {
            private final byte type;
            private final IRPZone.ID zoneid;
            private final int protocolVersion;

            public CacheKey(byte by, IRPZone.ID iD, int n) {
                this.type = by;
                this.zoneid = iD;
                this.protocolVersion = n;
            }

            public boolean equals(Object object) {
                if (object instanceof CacheKey) {
                    CacheKey cacheKey = (CacheKey)object;
                    if (cacheKey.type == this.type && cacheKey.zoneid.equals(this.zoneid) && cacheKey.protocolVersion == this.protocolVersion) {
                        return true;
                    }
                }
                return false;
            }

            public int hashCode() {
                return (this.type + 1) * this.zoneid.hashCode() * this.protocolVersion;
            }
        }
    }
}

