/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.adapter.DatabaseAdapter;
import marauroa.server.db.adapter.MySQLDatabaseAdapter;

class AdapterFactory {
    private static Logger logger = Log4J.getLogger(AdapterFactory.class);
    private final Properties connInfo;
    private boolean gotAConnection = false;

    public AdapterFactory(Properties properties) {
        this.connInfo = properties;
    }

    private DatabaseAdapter internalCreate() throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        String string = this.connInfo.getProperty("database_adapter");
        if (string == null) {
            return new MySQLDatabaseAdapter(this.connInfo);
        }
        Class<DatabaseAdapter> clazz = Class.forName(string).asSubclass(DatabaseAdapter.class);
        Constructor<DatabaseAdapter> constructor = clazz.getConstructor(Properties.class);
        return constructor.newInstance(this.connInfo);
    }

    public DatabaseAdapter create() {
        int n = Integer.parseInt(this.connInfo.getProperty("database_connection_retries", "2000000000"));
        int n2 = Integer.parseInt(this.connInfo.getProperty("database_connection_waittime", "1000"));
        int n3 = 0;
        while (true) {
            try {
                DatabaseAdapter databaseAdapter = this.internalCreate();
                this.gotAConnection = true;
                return databaseAdapter;
            }
            catch (Exception exception) {
                if (this.gotAConnection && n3 < n) {
                    logger.warn("Reconnect failed, will try again soon: " + exception);
                    ++n3;
                    try {
                        Thread.sleep(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error(interruptedException, interruptedException);
                    }
                    continue;
                }
                throw new RuntimeException(exception);
            }
            break;
        }
    }
}

