/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.StringChecker;
import marauroa.server.db.adapter.AbstractDatabaseAdapter;
import marauroa.server.db.adapter.CreateIndexStatementParser;

public class MySQLDatabaseAdapter
extends AbstractDatabaseAdapter {
    private static Logger logger = Log4J.getLogger(MySQLDatabaseAdapter.class);
    private int majorVersion;

    public MySQLDatabaseAdapter(Properties properties) throws DatabaseConnectionException {
        super(properties);
    }

    protected MySQLDatabaseAdapter() throws DatabaseConnectionException {
    }

    protected Connection createConnection(Properties properties) throws SQLException, DatabaseConnectionException {
        try {
            Connection connection = super.createConnection(properties);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            if (string.toLowerCase(Locale.ENGLISH).indexOf("mysql") < 0) {
                logger.warn("Using MySQLDatabaseAdapter to connect to " + string);
            }
            this.majorVersion = connection.getMetaData().getDatabaseMajorVersion();
            return connection;
        }
        catch (SQLException sQLException) {
            int n;
            String string = sQLException.toString();
            if (string.contains("CommunicationsException") && (n = string.indexOf("BEGIN NESTED EXCEPTION")) > -1) {
                throw new DatabaseConnectionException(string.substring(0, n - 3).trim());
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBaseTable(String string) throws SQLException {
        boolean bl = false;
        String string2 = "show full tables LIKE '" + StringChecker.escapeSQLString(string) + "'";
        ResultSet resultSet = this.query(string2);
        try {
            bl = resultSet.next();
            if (bl) {
                bl = "BASE TABLE".equals(resultSet.getString(2));
            }
        }
        finally {
            resultSet.close();
        }
        return bl;
    }

    private boolean doesIndexExist(String string, String string2) throws SQLException {
        String string3 = "SELECT count(1) FROM information_schema.statistics WHERE table_schema = database() AND table_name = '" + StringChecker.escapeSQLString(string) + "' AND index_name = '" + StringChecker.escapeSQLString(string2) + "'";
        return this.querySingleCellInt(string3) > 0;
    }

    protected String rewriteSql(String string) throws SQLException {
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        if (string3.startsWith("create table")) {
            string2 = this.rewriteSqlCreateTable(string2);
        } else if (string3.startsWith("create index") || string3.startsWith("create unique index")) {
            string2 = this.rewriteSqlCreateIndex(string2);
        }
        return string2;
    }

    private String rewriteSqlCreateIndex(String string) throws SQLException {
        boolean bl;
        CreateIndexStatementParser createIndexStatementParser = new CreateIndexStatementParser(string);
        boolean bl2 = bl = !this.isBaseTable(createIndexStatementParser.getTable()) || this.doesIndexExist(createIndexStatementParser.getTable(), createIndexStatementParser.getName());
        if (bl) {
            return "";
        }
        return createIndexStatementParser.toSqlWithoutIf();
    }

    private String rewriteSqlCreateTable(String string) {
        String string2 = this.majorVersion >= 5 ? string.substring(0, string.length() - 1) + " ENGINE=InnoDB;" : string.substring(0, string.length() - 1) + " TYPE=InnoDB;";
        return string2;
    }
}

