/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import marauroa.server.db.command.DBCommand;
import marauroa.server.db.command.ResultHandle;

class DBCommandMetaData {
    private DBCommand command;
    private ResultHandle handle;
    private Thread requestingThread;
    private boolean awaitResult;
    private long processedTimestamp = -1L;
    private Locale locale;

    public DBCommandMetaData(DBCommand dBCommand, ResultHandle resultHandle, Thread thread, boolean bl, Locale locale) {
        this.command = dBCommand;
        this.handle = resultHandle;
        this.requestingThread = thread;
        this.awaitResult = bl;
        this.locale = locale;
        dBCommand.setEnqueueTime(new Timestamp(new Date().getTime()));
    }

    public DBCommand getCommand() {
        return this.command;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Thread getRequestingThread() {
        return this.requestingThread;
    }

    public boolean isResultAwaited() {
        return this.awaitResult;
    }

    public long getProcessedTimestamp() {
        return this.processedTimestamp;
    }

    public void setProcessedTimestamp(long l) {
        this.processedTimestamp = l;
    }

    public ResultHandle getResultHandle() {
        return this.handle;
    }

    public String toString() {
        return "[" + this.requestingThread.getName() + ": " + this.command + "]";
    }
}

