/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.MarauroaUncaughtExceptionHandler;
import marauroa.common.crypto.Hash;
import marauroa.common.crypto.RSAKey;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.GameServerManager;
import marauroa.server.game.Statistics;
import marauroa.server.game.db.DatabaseFactory;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.INetworkServerManager;
import marauroa.server.net.NetworkServerManager;

public class marauroad
extends Thread {
    private static final Logger logger = Log4J.getLogger(marauroad.class);
    private static final String VERSION = "3.9.5";
    private static marauroad marauroa;
    private INetworkServerManager netMan;
    private GameServerManager gameMan;
    private RPServerManager rpMan;

    private static void setArguments(String[] stringArray) {
        for (int i = 0; i != stringArray.length; ++i) {
            if (stringArray[i].equals("-c")) {
                Configuration.setConfigurationFile(stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].equals("-h")) continue;
            System.out.println("Marauroa - an open source multiplayer online framework for game development -");
            System.out.println("Running on version 3.9.5");
            System.out.println("Marauroa is released under the Gnu General Public License: LICENSE.txt");
            System.out.println();
            System.out.println("usage: [-c server.ini]");
            System.out.println("\t-c: to choose a configuration file different of marauroa.ini or to use a");
            System.out.println("\t    different location to the file.");
            System.out.println("\t-h: print this help message");
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (!marauroad.getMarauroa().init(stringArray)) {
            System.exit(-1);
        }
        marauroad.tryToStartWebSocketServerIfConfigured();
        marauroad.getMarauroa().start();
    }

    private static void tryToStartWebSocketServerIfConfigured() {
        try {
            Configuration configuration = Configuration.getConfiguration();
            if (!configuration.has("http_port")) {
                return;
            }
            Class<?> clazz = Class.forName("marauroa.server.net.web.WebSocketServer");
            clazz.getMethod("startWebSocketServer", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            logger.warn("Trying to start webserver failed:", exception);
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            logger.warn("The websocket server requires a newer version of the Java Runtime: ", unsupportedClassVersionError);
        }
    }

    private void createBeanForStatistics() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Statistics statistics = Statistics.getStatistics();
            ObjectName objectName = new ObjectName("marauroad:name=Statistics");
            mBeanServer.registerMBean(statistics, objectName);
            logger.debug("Statistics bean registered.");
        }
        catch (Exception exception) {
            logger.error("cannot register statistics bean, continuing anyway.", exception);
        }
    }

    public synchronized void run() {
        logger.debug("marauroad thread started");
        boolean bl = false;
        while (!bl) {
            try {
                Statistics.getStatistics().print();
                this.wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        this.finish();
        logger.debug("exiting marauroad thread");
    }

    protected marauroad() {
        super("marauroad");
    }

    public static marauroad getMarauroa() {
        if (marauroa == null) {
            marauroa = new marauroad();
        }
        return marauroa;
    }

    public boolean init(String[] stringArray) {
        long l = System.currentTimeMillis();
        System.out.println("Starting Marauroa https://arianne-project.org/engine/marauroa.html");
        System.out.println("Arianne's open source multiplayer online framework for game development");
        System.out.println("Marauroa is released under the GNU General Public License: LICENSE.txt");
        System.out.println();
        try {
            Log4J.init("marauroa/server/log4j.properties");
        }
        catch (Exception exception) {
            System.out.println("ERROR: Marauroa can't initialize logging.");
            System.out.println("Verify you have created log/ directory.");
            System.exit(1);
        }
        logger.debug("staring initialize");
        this.createBeanForStatistics();
        marauroad.setArguments(stringArray);
        try {
            Configuration.getConfiguration().get("x");
        }
        catch (IOException iOException) {
            System.out.println("ERROR: Marauroa can't find configuration file.");
            System.out.println("Run game configuration to get a valid \"server.ini\" file");
            System.exit(1);
        }
        try {
            new DatabaseFactory().initializeDatabase();
        }
        catch (DatabaseConnectionException databaseConnectionException) {
            System.out.println("ERROR: Marauroa can't connect to database");
            System.out.println("Verify \"server.ini\" file to make sure access to database configuration is correct.");
            System.exit(1);
        }
        MarauroaUncaughtExceptionHandler.setup(true);
        new Thread(){

            public void run() {
                Hash.random(4);
            }
        }.start();
        try {
            this.netMan = new NetworkServerManager();
            this.netMan.start();
        }
        catch (Exception exception) {
            logger.error("Marauroa can't create NetworkServerManager.\nPossible Reasons:\n- You are already running a copy of Marauroa on the same TCP port\n- You haven't specified a valid configuration file\n- You haven't create database\n- You have invalid username and password to connect to database\n", exception);
            return false;
        }
        try {
            this.rpMan = new RPServerManager(this.netMan);
            this.rpMan.start();
        }
        catch (Exception exception) {
            logger.error("Marauroa can't create RPServerManager.\nPossible Reasons:\n- You haven't specified a valid configuration file\n- You haven't correctly filled the values related to game configuration. Use generateini application to create a valid configuration file.\n- There may be an error in the Game startup method.\n", exception);
            return false;
        }
        try {
            if (Configuration.getConfiguration().get("n") == null) {
                throw new Exception("Missing RSA key pair in server.ini; run marauroa.tools.GenerateKeys");
            }
            RSAKey rSAKey = new RSAKey(new BigInteger(Configuration.getConfiguration().get("n")), new BigInteger(Configuration.getConfiguration().get("d")), new BigInteger(Configuration.getConfiguration().get("e")));
            this.gameMan = new GameServerManager(rSAKey, this.netMan, this.rpMan);
            this.gameMan.start();
        }
        catch (Exception exception) {
            logger.error("Marauroa can't create GameServerManager.\nPossible Reasons:\n- You haven't specified a valid configuration file\n- You haven't correctly filled the values related to server information configuration. Use generateini application to create a valid configuration file.\n", exception);
            return false;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){
            private final Logger log = Log4J.getLogger(marauroad.class);

            public void run() {
                this.log.warn("User requesting shutdown");
                marauroad.this.finish();
                this.log.info("Shutdown completed. See you later!");
            }
        });
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        logger.info("marauroa 3.9.5 is up and running... (startup time: " + (double)((long)(d * 10.0)) / 10.0 + " s)");
        return true;
    }

    public INetworkServerManager getNetMan() {
        return this.netMan;
    }

    public RPServerManager getRPServerManager() {
        return this.rpMan;
    }

    public void finish() {
        this.netMan.finish();
        this.gameMan.finish();
        DBCommandQueue.get().finish();
    }
}

