/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.net.nio.ChangeRequest;
import marauroa.server.net.nio.IWorker;

class NioServer
extends Thread {
    private static final int BACKLOG_WARNING_SIZE = 10;
    private static final Logger logger = Log4J.getLogger(NioServer.class);
    private final InetAddress hostAddress;
    private final int port;
    private boolean keepRunning = true;
    private boolean isFinished = false;
    private ServerSocketChannel serverChannel;
    private final Selector selector;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(8192);
    private final IWorker worker;
    private final List<ChangeRequest> pendingChanges = new LinkedList<ChangeRequest>();
    private final List<ChangeRequest> pendingClosed;
    private final Map<SocketChannel, List<ByteBuffer>> pendingData = new HashMap<SocketChannel, List<ByteBuffer>>();

    public NioServer(InetAddress inetAddress, int n, IWorker iWorker) throws IOException {
        super("NioServer");
        this.hostAddress = inetAddress;
        this.port = n;
        this.selector = this.initSelector();
        this.worker = iWorker;
        this.worker.setServer(this);
        this.pendingClosed = new LinkedList<ChangeRequest>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SocketChannel socketChannel) {
        this.worker.onDisconnect(socketChannel);
        List<ChangeRequest> list = this.pendingClosed;
        synchronized (list) {
            this.pendingClosed.add(new ChangeRequest(socketChannel, 3, 0));
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(SocketChannel socketChannel, byte[] byArray) {
        List<ChangeRequest> list = this.pendingChanges;
        synchronized (list) {
            this.pendingChanges.add(new ChangeRequest(socketChannel, 2, 4));
            Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
            synchronized (map) {
                List<ByteBuffer> list2 = this.pendingData.get(socketChannel);
                if (list2 == null) {
                    list2 = new ArrayList<ByteBuffer>();
                    this.pendingData.put(socketChannel, list2);
                }
                list2.add(ByteBuffer.wrap(byArray));
                if (list2.size() > 10) {
                    logger.debug(socketChannel + ": " + list2.size());
                }
            }
        }
        this.selector.wakeup();
    }

    public void finish() {
        this.keepRunning = false;
        this.selector.wakeup();
        while (!this.isFinished) {
            Thread.yield();
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.keepRunning) {
            try {
                SelectionKey selectionKey;
                Object object = this.pendingChanges;
                synchronized (object) {
                    for (ChangeRequest changeRequest : this.pendingChanges) {
                        if (!changeRequest.socket.isConnected() || changeRequest.type != 2 || (selectionKey = changeRequest.socket.keyFor(this.selector)) == null || !selectionKey.isValid()) continue;
                        selectionKey.interestOps(changeRequest.ops);
                    }
                    this.pendingChanges.clear();
                }
                object = this.pendingClosed;
                synchronized (object) {
                    for (ChangeRequest changeRequest : this.pendingClosed) {
                        if (changeRequest.socket.isConnected()) {
                            if (changeRequest.type != 3) continue;
                            try {
                                if (this.pendingData.containsKey(changeRequest.socket) && (selectionKey = changeRequest.socket.keyFor(this.selector)).isValid()) {
                                    this.write(selectionKey);
                                }
                                changeRequest.socket.close();
                            }
                            catch (Exception exception) {
                                logger.info("Exception happened when closing socket", exception);
                            }
                            break;
                        }
                        logger.info("Closing a not connected socket");
                    }
                    this.pendingClosed.clear();
                }
                this.selector.select();
                object = this.selector.selectedKeys().iterator();
                while (object.hasNext()) {
                    SelectionKey selectionKey2 = (SelectionKey)object.next();
                    object.remove();
                    if (!selectionKey2.isValid()) continue;
                    if (selectionKey2.isAcceptable()) {
                        this.accept(selectionKey2);
                        continue;
                    }
                    if (selectionKey2.isReadable()) {
                        this.read(selectionKey2);
                        continue;
                    }
                    if (!selectionKey2.isWritable()) continue;
                    this.write(selectionKey2);
                }
            }
            catch (IOException iOException) {
                logger.error("Error on NIOServer", iOException);
            }
            catch (RuntimeException runtimeException) {
                logger.error("Error on NIOServer", runtimeException);
            }
        }
        this.isFinished = true;
    }

    private void accept(SelectionKey selectionKey) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.register(this.selector, 1);
        this.worker.onConnect(socketChannel);
    }

    private void read(SelectionKey selectionKey) {
        int n;
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        this.readBuffer.clear();
        try {
            n = socketChannel.read(this.readBuffer);
        }
        catch (IOException iOException) {
            logger.debug("Remote closed connnection", iOException);
            selectionKey.cancel();
            this.close(socketChannel);
            return;
        }
        if (n == -1) {
            logger.debug("Remote closed connnection cleanly");
            this.close((SocketChannel)selectionKey.channel());
            selectionKey.cancel();
            return;
        }
        this.worker.onData(this, socketChannel, this.readBuffer.array(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey selectionKey) {
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        Map<SocketChannel, List<ByteBuffer>> map = this.pendingData;
        synchronized (map) {
            List<ByteBuffer> list = this.pendingData.get(socketChannel);
            try {
                while (!list.isEmpty()) {
                    ByteBuffer byteBuffer = list.get(0);
                    socketChannel.write(byteBuffer);
                    if (byteBuffer.remaining() > 0) break;
                    list.remove(0);
                }
                if (list.isEmpty()) {
                    selectionKey.interestOps(1);
                }
            }
            catch (IOException iOException) {
                logger.debug("Remote closed connnection", iOException);
                list.clear();
                selectionKey.cancel();
                this.close(socketChannel);
                return;
            }
        }
    }

    private Selector initSelector() throws IOException {
        AbstractSelector abstractSelector = SelectorProvider.provider().openSelector();
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.hostAddress, this.port);
        this.serverChannel.socket().bind(inetSocketAddress);
        this.serverChannel.socket().setPerformancePreferences(0, 2, 1);
        this.serverChannel.register(abstractSelector, 16);
        return abstractSelector;
    }
}

