/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.validator;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.Channel;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.game.dbcommand.LoadBanListCommand;
import marauroa.server.game.messagehandler.DelayedEventHandler;
import marauroa.server.game.rp.RPServerManager;
import marauroa.server.net.validator.InetAddressMask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionValidator
implements Iterable<InetAddressMask>,
DelayedEventHandler {
    private static final Logger logger = Log4J.getLogger(ConnectionValidator.class);
    private final List<InetAddressMask> permanentBans = Collections.synchronizedList(new LinkedList());
    List<InetAddressMask> temporalBans = Collections.synchronizedList(new LinkedList());
    private final Timer timer = new Timer();
    private long lastLoadTS;
    private static final long RELOAD_PERMANENT_BANS = 300000L;

    public void finish() {
        this.timer.cancel();
    }

    public void addBan(Channel channel, int n) {
        this.addBan(channel.getInetAddress().getHostAddress(), "255.255.255.255", n);
    }

    public void addBan(String string, String string2, long l) {
        InetAddressMask inetAddressMask = new InetAddressMask(string, string2);
        this.timer.schedule((TimerTask)new RemoveBan(inetAddressMask), l);
        this.temporalBans.add(inetAddressMask);
    }

    public boolean removeBan(String string, String string2) {
        return this.temporalBans.remove(new InetAddressMask(string, string2));
    }

    @Override
    public Iterator<InetAddressMask> iterator() {
        return this.temporalBans.iterator();
    }

    public synchronized boolean checkBanned(InetAddress inetAddress) {
        this.checkReload();
        for (InetAddressMask inetAddressMask : this.temporalBans) {
            if (!inetAddressMask.matches(inetAddress)) continue;
            logger.debug("Address " + inetAddress + " is banned by " + inetAddressMask);
            return true;
        }
        for (InetAddressMask inetAddressMask : this.permanentBans) {
            if (!inetAddressMask.matches(inetAddress)) continue;
            logger.debug("Address " + inetAddress + " is permanently banned by " + inetAddressMask);
            return true;
        }
        return false;
    }

    @Override
    public void handleDelayedEvent(RPServerManager rPServerManager, Object object) {
        LoadBanListCommand loadBanListCommand = (LoadBanListCommand)object;
        this.permanentBans.clear();
        this.permanentBans.addAll(loadBanListCommand.getPermanentBans());
        this.lastLoadTS = System.currentTimeMillis();
    }

    public synchronized void checkReload() {
        if (System.currentTimeMillis() - this.lastLoadTS >= 300000L) {
            DBCommandQueue.get().enqueue(new LoadBanListCommand(this));
        }
    }

    private class RemoveBan
    extends TimerTask {
        private final InetAddressMask mask;

        public RemoveBan(InetAddressMask inetAddressMask) {
            this.mask = inetAddressMask;
        }

        public void run() {
            ConnectionValidator.this.temporalBans.remove(this.mask);
        }
    }
}

