/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import javax.servlet.http.HttpSession;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.io.UnicodeSupportingInputStreamReader;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.net.web.WebSocketConnectionManager;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class WebSocketChannel
extends WebSocketAdapter {
    private static Logger logger = Log4J.getLogger(WebSocketChannel.class);
    private static WebSocketConnectionManager webSocketServerManager = WebSocketConnectionManager.get();
    private String username;
    private String useragent;
    private InetSocketAddress address;

    public void onWebSocketConnect(Session session) {
        super.onWebSocketConnect(session);
        this.address = session.getRemoteAddress();
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        this.useragent = upgradeRequest.getHeader("User-Agent");
        this.username = this.extractUsernameFromSession(upgradeRequest);
        webSocketServerManager.onConnect(this);
        logger.debug("Socket Connected: " + session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractUsernameFromSession(UpgradeRequest upgradeRequest) {
        Object object;
        HttpSession httpSession = (HttpSession)upgradeRequest.getSession();
        if (httpSession != null && (object = (String)httpSession.getAttribute("marauroa_authenticated_username")) != null) {
            return object;
        }
        if (upgradeRequest.getCookies() == null) {
            return null;
        }
        for (HttpCookie httpCookie : upgradeRequest.getCookies()) {
            if (!httpCookie.getName().equals("PHPSESSID")) continue;
            String string = httpCookie.getValue();
            if (!string.matches("[A-Za-z0-9]+")) {
                logger.warn("Invalid PHPSESSID=" + string);
                continue;
            }
            BufferedReader bufferedReader = null;
            try {
                String string2 = Configuration.getConfiguration().get("php_session_file_prefix", "/var/lib/php5/sess_");
                String string3 = string2 + string;
                if (new File(string3).canRead()) {
                    String string4;
                    bufferedReader = new BufferedReader(new UnicodeSupportingInputStreamReader(new FileInputStream(string3)));
                    while ((string4 = bufferedReader.readLine()) != null) {
                        int n = string4.indexOf("marauroa_authenticated_username|s:");
                        if (n < 0) continue;
                        n = string4.indexOf("\"", n);
                        int n2 = string4.indexOf("\"", n + 2);
                        if (n <= -1 || n2 <= -1) continue;
                        logger.debug("php session username: " + string4.substring(n + 1, n2));
                        String string5 = string4.substring(n + 1, n2);
                        return string5;
                    }
                    continue;
                }
                logger.warn("Cannot read php session file: " + string3);
            }
            catch (IOException iOException) {
                logger.error(iOException, iOException);
            }
            finally {
                if (bufferedReader == null) continue;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.error(iOException, iOException);
                }
            }
        }
        return null;
    }

    public void onWebSocketText(String string) {
        String string2 = DebugInterface.get().onMessage(this.useragent, string);
        super.onWebSocketText(string2);
        webSocketServerManager.onMessage(this, string2);
    }

    public void onWebSocketClose(int n, String string) {
        super.onWebSocketClose(n, string);
        webSocketServerManager.onDisconnect(this);
        logger.debug("Socket Closed: [" + n + "] " + string);
    }

    public void onWebSocketError(Throwable throwable) {
        super.onWebSocketError(throwable);
        if (throwable instanceof SocketTimeoutException) {
            this.onWebSocketClose(-1, "Timeout");
            return;
        }
        logger.error(throwable, throwable);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getUsername() {
        return this.username;
    }

    public void sendMessage(String string) {
        try {
            RemoteEndpoint remoteEndpoint = this.getRemote();
            if (remoteEndpoint != null) {
                remoteEndpoint.sendString(string);
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
    }

    public void close() {
    }
}

