/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class GameLoop {
    private static final Logger logger = Logger.getLogger(GameLoop.class);
    private final Thread loopThread;
    private PersistentTask persistentTask;
    private final Queue<Runnable> temporaryTasks = new ConcurrentLinkedQueue<Runnable>();
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();
    private volatile boolean running;

    private GameLoop() {
        this.loopThread = new Thread(new Runnable(){

            @Override
            public void run() {
                GameLoop.this.loop();
                for (Runnable runnable : GameLoop.this.cleanupTasks) {
                    runnable.run();
                }
            }
        }, "Game loop");
    }

    public static GameLoop get() {
        return Holder.instance;
    }

    public static boolean isGameLoop() {
        return Thread.currentThread() == GameLoop.get().loopThread;
    }

    public void start() {
        this.running = true;
        this.loopThread.start();
    }

    public void stop() {
        this.running = false;
    }

    public void runAllways(PersistentTask persistentTask) {
        this.persistentTask = persistentTask;
    }

    public void runAtQuit(Runnable runnable) {
        this.cleanupTasks.add(runnable);
    }

    public void runOnce(Runnable runnable) {
        this.temporaryTasks.add(runnable);
    }

    private void loop() {
        long l;
        int n = 0;
        long l2 = l = System.currentTimeMillis();
        while (this.running) {
            try {
                ++n;
                long l3 = System.currentTimeMillis();
                int n2 = (int)(l3 - l);
                l = l3;
                this.persistentTask.run(n2);
                Runnable runnable = this.temporaryTasks.poll();
                while (runnable != null) {
                    runnable.run();
                    runnable = this.temporaryTasks.poll();
                }
                if (logger.isDebugEnabled()) {
                    this.reportClientInfo(l, l2, n);
                    n = 0;
                    l2 = l;
                }
                logger.debug((Object)"Start sleeping");
                long l4 = 40L + l - System.currentTimeMillis();
                if (l4 > 0L) {
                    if (l4 > 100L) {
                        logger.info((Object)("Waiting " + l4 + " ms"));
                        l4 = 100L;
                    }
                    try {
                        Thread.sleep(l4);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error((Object)interruptedException, (Throwable)interruptedException);
                    }
                }
                logger.debug((Object)"End sleeping");
            }
            catch (RuntimeException runtimeException) {
                logger.error((Object)runtimeException, (Throwable)runtimeException);
            }
        }
    }

    private void reportClientInfo(long l, long l2, int n) {
        if (l - l2 >= 1000L) {
            logger.debug((Object)("FPS: " + n));
            long l3 = Runtime.getRuntime().freeMemory() / 1024L;
            long l4 = Runtime.getRuntime().totalMemory() / 1024L;
            logger.debug((Object)("Total/Used memory: " + l4 + "/" + (l4 - l3)));
        }
    }

    public static interface PersistentTask {
        public void run(int var1);
    }

    private static class Holder {
        static GameLoop instance = new GameLoop();

        private Holder() {
        }
    }
}

