/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.StaticGameLayers;
import games.stendhal.client.entity.Entity;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.NPC;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.factory.EntityFactory;
import games.stendhal.client.events.EventDispatcher;
import games.stendhal.client.listener.RPObjectChangeListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class GameObjects
implements RPObjectChangeListener,
Iterable<IEntity> {
    private static final Logger logger = Logger.getLogger(GameObjects.class);
    private final Map<FQID, IEntity> objects;
    private final StaticGameLayers collisionMap;
    private static GameObjects instance;
    private final List<GameObjectListener> gameObjectListeners = new CopyOnWriteArrayList<GameObjectListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameObjects createInstance(StaticGameLayers staticGameLayers) {
        Class<GameObjects> clazz = GameObjects.class;
        synchronized (GameObjects.class) {
            if (instance == null) {
                instance = new GameObjects(staticGameLayers);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static GameObjects getInstance() {
        if (instance == null) {
            throw new IllegalStateException("GameObject has not been initialized");
        }
        return instance;
    }

    public void addGameObjectListener(GameObjectListener gameObjectListener) {
        this.gameObjectListeners.add(gameObjectListener);
    }

    public void removeGameObjectListener(GameObjectListener gameObjectListener) {
        this.gameObjectListeners.remove(gameObjectListener);
    }

    private GameObjects(StaticGameLayers staticGameLayers) {
        this.objects = new HashMap<FQID, IEntity>();
        this.collisionMap = staticGameLayers;
    }

    @Override
    public Iterator<IEntity> iterator() {
        return this.objects.values().iterator();
    }

    public IEntity get(RPObject rPObject) {
        return this.objects.get(FQID.create(rPObject));
    }

    public IEntity get(RPObject.ID iD) {
        return this.objects.get(new FQID(iD));
    }

    void clear() {
        if (!this.objects.isEmpty()) {
            logger.debug((Object)"Game objects not empty!");
            for (IEntity iEntity : this) {
                logger.debug((Object)("Residual entity: " + iEntity));
                iEntity.release();
            }
            this.objects.clear();
        }
    }

    public boolean collides(IEntity iEntity) {
        Object object;
        if (iEntity instanceof Player && (((RPEntity)(object = (Player)iEntity)).isGhostMode() || ((RPEntity)object).ignoresCollision())) {
            return false;
        }
        if (iEntity instanceof NPC && ((RPEntity)(object = (NPC)iEntity)).ignoresCollision()) {
            return false;
        }
        object = iEntity.getArea();
        if (this.collisionMap.collides((Rectangle2D)object)) {
            return true;
        }
        for (IEntity iEntity2 : this.objects.values()) {
            if (!iEntity2.isObstacle(iEntity) || !((RectangularShape)object).intersects(iEntity2.getArea())) continue;
            return true;
        }
        return false;
    }

    public void update(int n) {
        for (IEntity iEntity : this.objects.values()) {
            iEntity.update(n);
        }
    }

    private IEntity add(RPObject rPObject) {
        IEntity iEntity = EntityFactory.createEntity(rPObject);
        if (iEntity != null) {
            this.objects.put(FQID.create(rPObject), iEntity);
        }
        return iEntity;
    }

    @Override
    public void onAdded(RPObject rPObject) {
        if (!rPObject.getRPClass().subclassOf("entity")) {
            logger.debug((Object)("Skipping non-entity object: " + rPObject));
            return;
        }
        IEntity iEntity = this.add(rPObject);
        if (iEntity == null) {
            logger.error((Object)("No entity for: " + rPObject));
        } else {
            if (iEntity.isOnGround()) {
                for (GameObjectListener gameObjectListener : this.gameObjectListeners) {
                    gameObjectListener.addEntity(iEntity);
                }
            }
            logger.debug((Object)("added " + iEntity));
        }
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        IEntity iEntity = this.objects.get(FQID.create(rPObject));
        if (iEntity instanceof Entity) {
            Entity entity = (Entity)iEntity;
            entity.onChangedAdded(rPObject, rPObject2);
            EventDispatcher.dispatchEvents(rPObject2, entity);
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        IEntity iEntity = this.objects.get(FQID.create(rPObject));
        if (iEntity instanceof Entity) {
            ((Entity)iEntity).onChangedRemoved(rPObject, rPObject2);
        }
    }

    @Override
    public void onRemoved(RPObject rPObject) {
        RPObject.ID iD = rPObject.getID();
        logger.debug((Object)("removed " + iD));
        IEntity iEntity = this.objects.remove(FQID.create(rPObject));
        if (iEntity != null) {
            for (GameObjectListener gameObjectListener : this.gameObjectListeners) {
                gameObjectListener.removeEntity(iEntity);
            }
            iEntity.release();
        }
    }

    @Override
    public void onSlotAdded(RPObject rPObject, String string, RPObject rPObject2) {
    }

    @Override
    public void onSlotChangedAdded(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
        IEntity iEntity = this.objects.get(FQID.create(rPObject));
        if (iEntity instanceof Entity) {
            ((Entity)iEntity).onSlotChangedAdded(rPObject, string, rPObject2, rPObject3);
        }
    }

    @Override
    public void onSlotChangedRemoved(RPObject rPObject, String string, RPObject rPObject2, RPObject rPObject3) {
        IEntity iEntity = this.objects.get(FQID.create(rPObject));
        if (iEntity instanceof Entity) {
            ((Entity)iEntity).onSlotChangedRemoved(rPObject, string, rPObject2, rPObject3);
        }
    }

    @Override
    public void onSlotRemoved(RPObject rPObject, String string, RPObject rPObject2) {
    }

    public static interface GameObjectListener {
        public void addEntity(IEntity var1);

        public void removeEntity(IEntity var1);
    }

    private static class FQID {
        private Object[] path;

        private FQID(RPObject.ID iD) {
            this(new Object[]{iD.getObjectID()});
        }

        private FQID(Object[] objectArray) {
            this.path = objectArray;
        }

        private static FQID create(RPObject rPObject) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            RPObject rPObject2 = rPObject;
            while (true) {
                linkedList.addFirst(rPObject2.getID().getObjectID());
                RPSlot rPSlot = rPObject2.getContainerSlot();
                if (rPSlot == null) break;
                linkedList.addFirst(rPSlot.getName());
                rPObject2 = rPObject2.getContainer();
            }
            return new FQID(linkedList.toArray());
        }

        private Object[] getPath() {
            return this.path;
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof FQID ? Arrays.equals(this.getPath(), ((FQID)object).getPath()) : false;
            return bl;
        }

        public int hashCode() {
            int n = 0;
            for (Object object : this.getPath()) {
                n ^= object.hashCode();
            }
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(this.path[0]);
            for (int i = 1; i < this.path.length; ++i) {
                stringBuilder.append(':');
                stringBuilder.append(this.path[i]);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

