/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.gui.OutfitColor;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteCache;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import org.apache.log4j.Logger;

public class OutfitStore {
    private Logger logger = Logger.getLogger(OutfitStore.class);
    final String outfits = "data/sprites/outfit";
    final String bodies;
    final String dresses = "data/sprites/outfit/dress";
    final String heads;
    final String mouths = "data/sprites/outfit/mouth";
    final String eyes = "data/sprites/outfit/eyes";
    final String hairs = "data/sprites/outfit/hair";
    final String details = "data/sprites/outfit/detail";
    private static final OutfitStore sharedInstance = new OutfitStore(SpriteStore.get());
    private SpriteStore store;

    private OutfitStore(SpriteStore spriteStore) {
        this.store = spriteStore;
        this.bodies = "data/sprites/outfit/body";
        this.heads = "data/sprites/outfit/head";
    }

    private Sprite buildOutfit(int n, OutfitColor outfitColor) {
        int n2 = n % 100;
        int n3 = (n /= 100) % 100;
        int n4 = (n /= 100) % 100;
        int n5 = (n /= 100) % 100;
        int n6 = (n /= 100) % 100;
        Sprite sprite = this.getBodySprite(n2, outfitColor);
        if (sprite == null) {
            throw new IllegalArgumentException("No body image found for outfit: " + n2);
        }
        ImageSprite imageSprite = new ImageSprite(sprite);
        Graphics graphics = imageSprite.getGraphics();
        sprite = this.getDressSprite(n3, outfitColor);
        sprite.draw(graphics, 0, 0);
        sprite = this.getHeadSprite(n4, outfitColor);
        sprite.draw(graphics, 0, 0);
        sprite = this.getHairSprite(n5, outfitColor);
        sprite.draw(graphics, 0, 0);
        sprite = this.getDetailSprite(n6, outfitColor);
        sprite.draw(graphics, 0, 0);
        return imageSprite;
    }

    private Sprite buildOutfit(long l, OutfitColor outfitColor) {
        int n = (int)(l / 10000L);
        Sprite sprite = this.buildOutfit(n, outfitColor);
        int n2 = (int)(l % 100L);
        int n3 = (int)((l /= 100L) % 100L);
        ImageSprite imageSprite = new ImageSprite(sprite);
        Graphics graphics = imageSprite.getGraphics();
        sprite = this.getMouthSprite(n2);
        sprite.draw(graphics, 0, 0);
        sprite = this.getEyesSprite(n3, outfitColor);
        sprite.draw(graphics, 0, 0);
        return imageSprite;
    }

    public static OutfitStore get() {
        return sharedInstance;
    }

    public String getSpriteSuffix(int n) {
        String string = n < 10 ? "00" + Integer.toString(n) : (n < 100 ? "0" + Integer.toString(n) : Integer.toString(n));
        return string;
    }

    public Sprite getBodySprite(int n, OutfitColor outfitColor) {
        String string = this.getSpriteSuffix(n);
        String string2 = this.bodies + "/body_" + string + ".png";
        if (!this.store.existsSprite(string2)) {
            return null;
        }
        return this.store.getColoredSprite(string2, outfitColor.getColor("skin"));
    }

    public Sprite getDressSprite(int n, OutfitColor outfitColor) {
        if (n == 0) {
            return this.getEmptySprite();
        }
        String string = this.getSpriteSuffix(n);
        String string2 = "data/sprites/outfit/dress/dress_" + string + ".png";
        return this.store.getColoredSprite(string2, outfitColor.getColor("dress"));
    }

    private Sprite getEmptySprite() {
        return this.store.getEmptySprite();
    }

    public Sprite getFailsafeOutfit() {
        try {
            return this.getOutfit(0, OutfitColor.PLAIN);
        }
        catch (RuntimeException runtimeException) {
            this.logger.warn((Object)"Cannot build failsafe outfit. Trying to use standard failsafe sprite.", (Throwable)runtimeException);
            return this.store.getFailsafe();
        }
    }

    public Sprite getHairSprite(int n, OutfitColor outfitColor) {
        if (n == 0) {
            return this.getEmptySprite();
        }
        String string = this.getSpriteSuffix(n);
        String string2 = "data/sprites/outfit/hair/hair_" + string + ".png";
        return this.store.getColoredSprite(string2, outfitColor.getColor("hair"));
    }

    public Sprite getEyesSprite(int n, OutfitColor outfitColor) {
        String string = this.getSpriteSuffix(n);
        String string2 = "data/sprites/outfit/eyes/eyes_" + string + ".png";
        if (!this.store.existsSprite(string2)) {
            return null;
        }
        return this.store.getColoredSprite(string2, outfitColor.getColor("eyes"));
    }

    public Sprite getMouthSprite(int n) {
        String string = this.getSpriteSuffix(n);
        String string2 = "data/sprites/outfit/mouth/mouth_" + string + ".png";
        if (!this.store.existsSprite(string2)) {
            return null;
        }
        return this.store.getSprite(string2);
    }

    public Sprite getHeadSprite(int n, OutfitColor outfitColor) {
        String string = this.getSpriteSuffix(n);
        String string2 = this.heads + "/head_" + string + ".png";
        if (!this.store.existsSprite(string2)) {
            return null;
        }
        return this.store.getColoredSprite(string2, outfitColor.getColor("skin"));
    }

    private Sprite getDetailSprite(int n, OutfitColor outfitColor) {
        if (n == 0) {
            return this.getEmptySprite();
        }
        String string = this.getSpriteSuffix(n);
        String string2 = "data/sprites/outfit/detail/detail_" + string + ".png";
        return this.store.getColoredSprite(string2, outfitColor.getColor("detail"));
    }

    private Sprite getOutfit(int n, OutfitColor outfitColor) {
        String string = this.buildReference(n, outfitColor.toString());
        return this.getOutfit(n, outfitColor, string);
    }

    private Sprite getOutfit(long l, OutfitColor outfitColor) {
        String string = this.buildReference(l, outfitColor.toString());
        return this.getOutfit(l, outfitColor, string);
    }

    private Sprite getOutfit(int n, OutfitColor outfitColor, String string) {
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string);
        if (sprite == null) {
            sprite = this.buildOutfit(n, outfitColor);
            spriteCache.add(string, sprite);
        }
        return sprite;
    }

    private Sprite getOutfit(long l, OutfitColor outfitColor, String string) {
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string);
        if (sprite == null) {
            sprite = this.buildOutfit(l, outfitColor);
            spriteCache.add(string, sprite);
        }
        return sprite;
    }

    public Sprite getAdjustedOutfit(int n, OutfitColor outfitColor, Color color, Composite composite) {
        String string;
        String string2;
        if (color == null || composite == null) {
            return this.getOutfit(n, outfitColor);
        }
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string2 = (string = this.buildReference(n, outfitColor.toString())) + ":" + color.getRGB() + composite.toString());
        if (sprite == null) {
            Sprite sprite2 = this.getOutfit(n, outfitColor);
            SpriteStore spriteStore = SpriteStore.get();
            sprite = spriteStore.modifySprite(sprite2, color, composite, string2);
        }
        return sprite;
    }

    public Sprite getAdjustedOutfit(long l, OutfitColor outfitColor, Color color, Composite composite) {
        String string;
        String string2;
        if (color == null || composite == null) {
            return this.getOutfit(l, outfitColor);
        }
        SpriteCache spriteCache = SpriteCache.get();
        Sprite sprite = spriteCache.get(string2 = (string = this.buildReference(l, outfitColor.toString())) + ":" + color.getRGB() + composite.toString());
        if (sprite == null) {
            Sprite sprite2 = this.getOutfit(l, outfitColor);
            SpriteStore spriteStore = SpriteStore.get();
            sprite = spriteStore.modifySprite(sprite2, color, composite, string2);
        }
        return sprite;
    }

    private String buildReference(int n, String string) {
        return "OUTFIT:" + n + "@" + string;
    }

    private String buildReference(long l, String string) {
        return "OUTFIT:" + Long.toString(l) + "@" + string;
    }
}

