/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client;

import games.stendhal.client.MemoryCache;
import games.stendhal.client.sprite.DataLoader;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.client.sprite.SpriteTileset;
import games.stendhal.client.sprite.Tileset;
import games.stendhal.client.sprite.TilesetAnimationMap;
import games.stendhal.client.sprite.TilesetGroupAnimationMap;
import games.stendhal.common.tiled.TileSetDefinition;
import java.awt.Color;
import java.awt.Composite;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.Serializable;
import org.apache.log4j.Logger;

class TileStore
implements Tileset {
    private static final Logger logger = Logger.getLogger(TileStore.class);
    private static final String baseFolder = TileStore.getResourceBase();
    private static final TilesetGroupAnimationMap animationMap = TileStore.createAnimationMap();
    private static final MemoryCache<String, Tileset> tilesetsLoaded = new MemoryCache();
    private final SpriteStore store;
    private final ArrayList<Sprite> tiles;
    private final List<TileSetDefinition> tilesets = new ArrayList<TileSetDefinition>();
    private boolean validated;

    public static TilesetGroupAnimationMap getAnimationMap() {
        return animationMap;
    }

    public TileStore() {
        this(SpriteStore.get());
    }

    private TileStore(SpriteStore spriteStore) {
        this.store = spriteStore;
        this.tiles = new ArrayList();
        this.tiles.add(spriteStore.getEmptySprite());
    }

    private void add(TileSetDefinition tileSetDefinition, Color color, Composite composite) {
        String string;
        Tileset tileset;
        int n;
        int n2;
        String string2 = tileSetDefinition.getSource();
        int n3 = tileSetDefinition.getFirstGid();
        if (string2.startsWith("../../")) {
            string2 = string2.substring(6);
        }
        if ((n2 = this.tiles.size()) > n3) {
            logger.debug((Object)("Tileset base index mismatch (" + n2 + " > " + n3 + "): " + string2));
            for (n = n3; n < n2; ++n) {
                this.tiles.remove(n3);
            }
        } else if (n2 < n3) {
            logger.debug((Object)("Tileset base index mismatch (" + n2 + " < " + n3 + "): " + string2));
            for (n = n2; n < n3; ++n) {
                this.tiles.add(null);
            }
        }
        if ((tileset = tilesetsLoaded.get(string = color != null && composite != null ? this.store.createModifiedRef(string2, color, composite) : string2)) == null) {
            tileset = new SpriteTileset(this.store, baseFolder + string2, color, composite);
            tilesetsLoaded.put(string, tileset);
        }
        int n4 = tileset.getSize();
        this.tiles.ensureCapacity(n3 + n4);
        for (int i = 0; i < n4; ++i) {
            this.tiles.add(tileset.getSprite(i));
        }
        TilesetAnimationMap tilesetAnimationMap = animationMap.get(string2);
        if (tilesetAnimationMap != null) {
            for (int i = 0; i < n4; ++i) {
                Sprite sprite = tilesetAnimationMap.getSprite(tileset, i);
                if (sprite == null) continue;
                this.tiles.set(n3 + i, sprite);
            }
        }
    }

    void addTilesets(InputSerializer inputSerializer) throws IOException, ClassNotFoundException {
        int n = inputSerializer.readInt();
        for (int i = 0; i < n; ++i) {
            TileSetDefinition tileSetDefinition = (TileSetDefinition)inputSerializer.readObject((Serializable)new TileSetDefinition(null, null, -1));
            this.tilesets.add(tileSetDefinition);
        }
    }

    boolean validate(Color color, Composite composite) {
        if (!this.validated) {
            if (!this.tilesets.isEmpty()) {
                for (TileSetDefinition tileSetDefinition : this.tilesets) {
                    this.add(tileSetDefinition, color, composite);
                }
                this.tilesets.clear();
                this.validated = true;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TilesetGroupAnimationMap createAnimationMap() {
        TilesetGroupAnimationMap tilesetGroupAnimationMap = new TilesetGroupAnimationMap();
        URL uRL = DataLoader.getResource(baseFolder + "tileset/animation.seq");
        if (uRL != null) {
            try (InputStream inputStream = uRL.openStream();){
                tilesetGroupAnimationMap.load(inputStream);
            }
            catch (IOException iOException) {
                logger.error((Object)"Error loading tileset animation map", (Throwable)iOException);
            }
        }
        return tilesetGroupAnimationMap;
    }

    private static String getResourceBase() {
        String string = "data/";
        if (DataLoader.getResource("tiled/tileset/README") != null) {
            logger.debug((Object)"Developing mode, loading tileset from tiled/tileset instead of data/tileset");
            string = "tiled/";
        }
        return string;
    }

    @Override
    public int getSize() {
        return this.tiles.size();
    }

    @Override
    public Sprite getSprite(int n) {
        if (n >= this.tiles.size()) {
            logger.error((Object)("Accessing unassigned sprite at: " + n));
            return this.store.getEmptySprite();
        }
        Sprite sprite = this.tiles.get(n);
        if (sprite == null) {
            logger.error((Object)("Accessing unassigned sprite at: " + n));
            return this.store.getEmptySprite();
        }
        return sprite;
    }
}

