/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.entity.ActiveEntity;
import games.stendhal.client.sound.facade.AudibleCircleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundGroup;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.common.Rand;
import games.stendhal.common.math.Algebra;
import java.util.ArrayList;
import java.util.HashMap;

abstract class AudibleEntity
extends ActiveEntity {
    private final AudibleCircleArea mAudibleArea = new AudibleCircleArea(Algebra.vecf(0.0f, 0.0f), 1.5f, 23.0f);
    private final HashMap<String, ArrayList<String>> mCategorys = new HashMap();
    private long mWaitTime = 0L;

    AudibleEntity() {
    }

    protected void addSounds(String string, String string2, String ... stringArray) {
        ArrayList<String> arrayList = this.mCategorys.get(string2);
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (String string3 : stringArray) {
            if (!soundGroup.loadSound(string3, string3 + ".ogg", SoundFileType.OGG, false)) continue;
            arrayList.add(string3);
        }
        if (arrayList.size() > 0) {
            this.mCategorys.put(string2, arrayList);
        }
    }

    private String getRandomSoundFromCategory(String string) {
        ArrayList<String> arrayList = this.mCategorys.get(string);
        if (arrayList != null && !arrayList.isEmpty()) {
            return Rand.rand(arrayList);
        }
        return null;
    }

    private String getSoundFromCategory(String string) {
        ArrayList<String> arrayList = this.mCategorys.get(string);
        if (arrayList != null && !arrayList.isEmpty()) {
            return arrayList.get(0);
        }
        return null;
    }

    private String getSoundFromCategory(String string, int n) {
        ArrayList<String> arrayList = this.mCategorys.get(string);
        if (arrayList != null && !arrayList.isEmpty()) {
            return arrayList.get(n);
        }
        return null;
    }

    @Override
    protected void onPosition(double d, double d2) {
        super.onPosition(d, d2);
        this.mAudibleArea.setPosition(Algebra.vecf((float)d, (float)d2));
        ClientSingletonRepository.getSound().update();
    }

    protected void playRandomSoundFromCategory(String string, String string2) {
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        soundGroup.play(this.getRandomSoundFromCategory(string2), 0, this.mAudibleArea, new Time(), false, true);
    }

    protected void playRandomSoundFromGroup(String string, String string2, long l) {
        if (this.mWaitTime < System.currentTimeMillis() && Rand.rand(100) < 5) {
            this.playRandomSoundFromCategory(string, string2);
            this.mWaitTime = System.currentTimeMillis() + l;
        }
    }

    protected void playSoundFromCategory(String string, String string2) {
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        soundGroup.play(this.getSoundFromCategory(string2), 0, this.mAudibleArea, new Time(), false, true);
    }

    protected void playSoundFromCategory(String string, String string2, int n) {
        SoundGroup soundGroup = ClientSingletonRepository.getSound().getGroup(string);
        soundGroup.play(this.getSoundFromCategory(string2, n), 0, this.mAudibleArea, new Time(), false, true);
    }
}

