/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.entity;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.GameObjects;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Player;
import games.stendhal.client.entity.RPEntity;
import games.stendhal.client.entity.SpeedPredictor;
import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.common.Direction;
import games.stendhal.common.NotificationType;
import games.stendhal.common.grammar.Grammar;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import marauroa.common.game.RPAction;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

public class User
extends Player {
    private static final Logger logger = Logger.getLogger(User.class);
    private static User instance;
    private static String groupLootmode;
    private static Set<String> groupMembers;
    private final HashSet<String> ignore = new HashSet();
    private final SpeedPredictor speedPredictor;

    public static boolean isNull() {
        return instance == null;
    }

    public static User get() {
        return instance;
    }

    public User() {
        this.speedPredictor = instance == null ? new SpeedPredictor() : new SpeedPredictor(User.instance.speedPredictor);
        instance = this;
    }

    @Override
    protected void onAway(String string) {
        super.onAway(string);
        String string2 = string == null ? "You are no longer marked as being away." : "You have been marked as being away.";
        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(string2, NotificationType.INFORMATION));
    }

    public static boolean isAdmin() {
        if (User.isNull()) {
            return false;
        }
        User user = User.get();
        if (user.rpObject == null) {
            return false;
        }
        return user.rpObject.has("adminlevel") && user.rpObject.getInt("adminlevel") >= 600;
    }

    public static int getPlayerLevel() {
        if (!User.isNull()) {
            User user = User.get();
            if (user.rpObject != null) {
                return user.getLevel();
            }
        }
        return 0;
    }

    public boolean hasSheep() {
        if (this.rpObject == null) {
            return false;
        }
        return this.rpObject.has("sheep");
    }

    public boolean hasPet() {
        if (this.rpObject == null) {
            return false;
        }
        return this.rpObject.has("pet");
    }

    public int getSheepID() {
        return this.rpObject.getInt("sheep");
    }

    public int getPetID() {
        return this.rpObject.getInt("pet");
    }

    @Override
    public void onHealed(int n) {
        super.onHealed(n);
        ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine(this.getTitle() + " heals " + Grammar.quantityplnoun(n, "health point") + ".", NotificationType.HEAL));
    }

    public Rectangle2D getHearingArea() {
        return new Rectangle2D.Double(this.getX() - 20.0, this.getY() - 20.0, 40.0, 40.0);
    }

    @Override
    public void onChangedAdded(RPObject rPObject, RPObject rPObject2) {
        super.onChangedAdded(rPObject, rPObject2);
        if (rPObject != null) {
            RPObject rPObject3;
            if (rPObject2.has("offline")) {
                for (RPObject rPObject4 : rPObject3 = rPObject2.get("offline").split(",")) {
                    ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine((String)rPObject4 + " has left Stendhal.", NotificationType.INFORMATION));
                }
            }
            if (rPObject2.has("online")) {
                for (RPObject rPObject4 : rPObject3 = rPObject2.get("online").split(",")) {
                    ClientSingletonRepository.getUserInterface().addEventLine(new HeaderLessEventLine((String)rPObject4 + " has joined Stendhal.", NotificationType.INFORMATION));
                }
            }
            if (rPObject2.hasSlot("!ignore") && (rPObject3 = rPObject2.getSlot("!ignore").getFirst()) != null) {
                this.addIgnore(rPObject3);
            }
        }
    }

    @Override
    public void onChangedRemoved(RPObject rPObject, RPObject rPObject2) {
        RPObject rPObject3;
        super.onChangedRemoved(rPObject, rPObject2);
        if (rPObject2.hasSlot("!ignore") && (rPObject3 = rPObject2.getSlot("!ignore").getFirst()) != null) {
            this.removeIgnore(rPObject3);
        }
    }

    static void setNull() {
        instance = null;
    }

    public int findItem(String string, String string2) {
        RPSlot rPSlot = this.getSlot(string);
        if (rPSlot == null) {
            return -1;
        }
        for (RPObject rPObject : rPSlot) {
            if (!rPObject.get("name").equals(string2)) continue;
            int n = rPObject.getID().getObjectID();
            return n;
        }
        return -1;
    }

    @Override
    public boolean isUser() {
        return true;
    }

    static double squaredDistanceTo(double d, double d2) {
        if (User.isNull()) {
            return Double.POSITIVE_INFINITY;
        }
        return (User.get().getX() - d) * (User.get().getX() - d) + (User.get().getY() - d2) * (User.get().getY() - d2);
    }

    public static boolean isIgnoring(String string) {
        if (User.isNull()) {
            return false;
        }
        return User.get().ignore.contains(string);
    }

    public static boolean hasBuddy(String string) {
        if (User.isNull()) {
            return false;
        }
        RPObject rPObject = User.get().rpObject;
        return rPObject.has("buddies", string);
    }

    public static String getServerRelease() {
        if (User.isNull()) {
            return null;
        }
        return User.get().rpObject.get("release");
    }

    public static String getCharacterName() {
        if (User.isNull()) {
            return null;
        }
        return User.get().getName();
    }

    private void addIgnore(RPObject rPObject) {
        for (String string : rPObject) {
            if (string.charAt(0) != '_') continue;
            this.ignore.add(string.substring(1));
        }
    }

    private void removeIgnore(RPObject rPObject) {
        for (String string : rPObject) {
            if (string.charAt(0) != '_') continue;
            this.ignore.remove(string.substring(1));
        }
    }

    public static boolean isGroupSharingLoot() {
        return groupLootmode != null && groupLootmode.equals("shared");
    }

    public static boolean isPlayerInGroup(String string) {
        if (groupMembers == null) {
            return false;
        }
        return groupMembers.contains(string);
    }

    public static void updateGroupStatus(List<String> list, String string) {
        Set<String> set = groupMembers;
        groupMembers = list == null ? null : new HashSet<String>(list);
        groupLootmode = string;
        for (IEntity iEntity : GameObjects.getInstance()) {
            if (!(iEntity instanceof Player) || (set == null || !set.contains(iEntity.getName())) && (groupMembers == null || !groupMembers.contains(iEntity.getName()))) continue;
            ((Player)iEntity).fireChange(RPEntity.PROP_GROUP_MEMBERSHIP);
        }
    }

    public String getZoneName() {
        return this.rpObject.getID().getZoneID();
    }

    @Override
    protected void processPositioning(RPObject rPObject, RPObject rPObject2) {
        if (this.speedPredictor.isActive() && (rPObject2.has("direction") || rPObject2.has("x") || rPObject2.has("y"))) {
            this.speedPredictor.onMoved();
        }
        super.processPositioning(rPObject, rPObject2);
    }

    public void predictMovement(Direction direction, boolean bl) {
        if (this.stopped()) {
            if (this.isConfused()) {
                direction = direction.oppositeDirection();
            }
            if (!bl) {
                double d = this.speedPredictor.getSpeed();
                this.setSpeed((double)direction.getdx() * d, (double)direction.getdy() * d);
                this.fireChange(PROP_SPEED);
                this.speedPredictor.startPrediction();
            }
            this.setDirection(direction);
        }
    }

    public Integer directionToKeyCode(Direction direction) {
        switch (direction) {
            case LEFT: {
                return 37;
            }
            case RIGHT: {
                return 39;
            }
            case UP: {
                return 38;
            }
            case DOWN: {
                return 40;
            }
        }
        return null;
    }

    public void stopMovement() {
        RPAction rPAction = new RPAction();
        rPAction.put("type", "walk");
        rPAction.put("mode", "stop");
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }
}

