/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.gui.AbstractColorSelector;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.sprite.ImageSprite;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.common.MathHelper;
import games.stendhal.common.color.ARGB;
import games.stendhal.common.color.HSL;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.colorchooser.DefaultColorSelectionModel;

class ColorSelector
extends AbstractColorSelector<HSLSelectionModel> {
    private final JComponent hueSaturationSelector;
    private final JComponent lightnessSelector;

    ColorSelector() {
        super(new HSLSelectionModel());
        HSLSelectionModel hSLSelectionModel = (HSLSelectionModel)this.getSelectionModel();
        this.hueSaturationSelector = new HueSaturationSelector(hSLSelectionModel);
        this.add(this.hueSaturationSelector);
        this.lightnessSelector = new LightnessSelector(hSLSelectionModel);
        this.add((Component)this.lightnessSelector, (Object)SLayout.EXPAND_X);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.hueSaturationSelector.setEnabled(bl);
        this.lightnessSelector.setEnabled(bl);
    }

    static class HSLSelectionModel
    extends DefaultColorSelectionModel {
        private float[] hsl = new float[3];

        HSLSelectionModel() {
        }

        @Override
        public void setSelectedColor(Color color) {
            if (color == null) {
                color = Color.GRAY;
            }
            int[] nArray = new int[4];
            ARGB.splitRgb(color.getRGB(), nArray);
            HSL.rgb2hsl(nArray, this.hsl);
            super.setSelectedColor(color);
        }

        void setHS(float f, float f2) {
            this.hsl[0] = f;
            this.hsl[1] = f2;
            this.updateColor();
        }

        void setL(float f) {
            this.hsl[2] = f;
            this.updateColor();
        }

        float getHue() {
            return this.hsl[0];
        }

        float getSaturation() {
            return this.hsl[1];
        }

        float getLightness() {
            return this.hsl[2];
        }

        private void updateColor() {
            int[] nArray = new int[4];
            HSL.hsl2rgb(this.hsl, nArray);
            nArray[0] = 255;
            super.setSelectedColor(new Color(ARGB.mergeRgb(nArray)));
        }
    }

    private static class LightnessSelector
    extends AbstractColorSelector.AbstractSelector<HSLSelectionModel> {
        private static final int BAR_HEIGHT = 10;

        LightnessSelector(HSLSelectionModel hSLSelectionModel) {
            super(hSLSelectionModel);
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            int n = 10 + insets.left + insets.right;
            int n2 = 10 + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Object object;
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getWidth() - insets.left - insets.right;
            if (this.isEnabled()) {
                object = new float[3];
                int[] nArray = new int[4];
                nArray[0] = 255;
                object[0] = ((HSLSelectionModel)this.model).getHue();
                object[1] = ((HSLSelectionModel)this.model).getSaturation();
                Color[] colorArray = new Color[3];
                object[2] = 0.08f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[0] = new Color(ARGB.mergeRgb(nArray));
                object[2] = 0.5f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[1] = new Color(ARGB.mergeRgb(nArray));
                object[2] = 0.92f;
                HSL.hsl2rgb((float[])object, nArray);
                colorArray[2] = new Color(ARGB.mergeRgb(nArray));
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(insets.left, 0.0f, n, 0.0f, new float[]{0.0f, 0.5f, 1.0f}, colorArray);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.fillRect(insets.left, insets.top, n, n2);
            } else {
                object = Color.BLACK;
                Color color = Color.WHITE;
                Graphics2D graphics2D = (Graphics2D)graphics;
                GradientPaint gradientPaint = new GradientPaint(insets.left, insets.top, (Color)object, n, insets.top, color);
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(insets.left, insets.top, n, n2);
            }
            graphics.setColor(Color.BLACK);
            int n3 = (int)(((HSLSelectionModel)this.model).getLightness() * (float)n) + insets.left;
            graphics.drawLine(n3, 0, n3, this.getHeight());
            graphics.setColor(Color.WHITE);
            graphics.drawLine(++n3, 0, n3, this.getHeight());
        }

        @Override
        void select(Point point) {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = point.x - insets.left;
            n2 = MathHelper.clamp(n2, 0, n);
            float f = (float)n2 / (float)n;
            f = MathHelper.clamp(f, 0.01f, 0.99f);
            ((HSLSelectionModel)this.model).setL(f);
        }

        @Override
        public void setEnabled(boolean bl) {
            boolean bl2 = this.isEnabled();
            super.setEnabled(bl);
            if (bl2 != bl) {
                this.repaint();
            }
        }
    }

    private static class HueSaturationSelector
    extends AbstractColorSelector.AbstractSpriteColorSelector<HSLSelectionModel> {
        HueSaturationSelector(HSLSelectionModel hSLSelectionModel) {
            super(hSLSelectionModel);
        }

        @Override
        Sprite createNormalSprite() {
            BufferedImage bufferedImage = this.getGraphicsConfiguration().createCompatibleImage(80, 52);
            float[] fArray = new float[3];
            fArray[2] = 0.5f;
            int[] nArray = new int[4];
            nArray[0] = 255;
            for (int i = 0; i < 80; ++i) {
                for (int j = 0; j < 52; ++j) {
                    fArray[0] = (float)i / 80.0f;
                    fArray[1] = 1.0f - (float)j / 52.0f;
                    HSL.hsl2rgb(fArray, nArray);
                    int n = ARGB.mergeRgb(nArray);
                    bufferedImage.setRGB(i, j, n);
                }
            }
            return new ImageSprite(bufferedImage, (Object)"hsl_color_selection_id");
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            graphics.setColor(Color.BLACK);
            int n = (int)(((HSLSelectionModel)this.model).getHue() * (float)sprite.getWidth()) + insets.left;
            int n2 = (int)((1.0f - ((HSLSelectionModel)this.model).getSaturation()) * (float)sprite.getHeight()) + insets.left;
            graphics.drawLine(n, 0, n, this.getHeight());
            graphics.drawLine(0, n2, this.getWidth(), n2);
        }

        @Override
        void select(Point point) {
            Insets insets = this.getInsets();
            Sprite sprite = this.getBackgroundSprite();
            int n = sprite.getWidth();
            int n2 = sprite.getHeight();
            int n3 = point.x - insets.left;
            n3 = MathHelper.clamp(n3, 0, n);
            float f = (float)n3 / (float)n;
            int n4 = point.y - insets.top;
            n4 = MathHelper.clamp(n4, 0, n2);
            float f2 = 1.0f - (float)n4 / (float)n2;
            ((HSLSelectionModel)this.model).setHS(f, f2);
        }
    }
}

