/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.StackableItem;
import games.stendhal.client.gui.DropAmountChooser;
import games.stendhal.client.gui.DropTarget;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.j2d.entity.EntityViewFactory;
import games.stendhal.client.gui.j2d.entity.StackableItem2DView;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DragLayer
extends JComponent
implements AWTEventListener {
    private static final long serialVersionUID = -726066169323112688L;
    private static DragLayer instance;
    private static final Sprite dropForbiddenIcon;
    private Entity2DView<?> dragged;
    private Point point;
    private int oldX;
    private int oldY;
    private int width;
    private int height;
    private Component underlyingComponent;

    private DragLayer() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
        this.setOpaque(false);
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    public static DragLayer get() {
        if (instance == null) {
            instance = new DragLayer();
        }
        return instance;
    }

    public void startDrag(IEntity iEntity) {
        if (iEntity != null) {
            Entity2DView entity2DView = (Entity2DView)EntityViewFactory.create(iEntity);
            entity2DView.setContained(true);
            if (entity2DView instanceof StackableItem2DView) {
                ((StackableItem2DView)entity2DView).setShowQuantity(false);
            }
            this.dragged = entity2DView;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.point != null && this.dragged != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(this.point.x, this.point.y);
            this.dragged.draw(graphics2D);
            if (this.getCurrentDropTarget() == null) {
                dropForbiddenIcon.draw(graphics2D, this.dragged.getWidth() - dropForbiddenIcon.getWidth(), this.dragged.getHeight() - dropForbiddenIcon.getHeight());
            }
        }
    }

    private DropTarget getCurrentDropTarget() {
        if (this.underlyingComponent == null) {
            Container container = this.getParent();
            Point point = SwingUtilities.convertPoint(this, this.point, container);
            this.underlyingComponent = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        }
        if (this.underlyingComponent instanceof DropTarget && ((DropTarget)((Object)this.underlyingComponent)).canAccept((IEntity)this.dragged.getEntity())) {
            return (DropTarget)((Object)this.underlyingComponent);
        }
        return null;
    }

    private void stopDrag(MouseEvent mouseEvent) {
        Object obj = this.dragged.getEntity();
        DropTarget dropTarget = this.getCurrentDropTarget();
        if (dropTarget != null && dropTarget.canAccept((IEntity)obj) && dropTarget instanceof Component && obj != null) {
            Point point = SwingUtilities.convertPoint(this, this.point, (Component)((Object)dropTarget));
            if (this.showAmountChooser(mouseEvent, (IEntity)obj)) {
                DropAmountChooser dropAmountChooser = new DropAmountChooser((StackableItem)obj, dropTarget, point);
                dropAmountChooser.show((Component)((Object)dropTarget), point);
            } else {
                dropTarget.dropEntity((IEntity)obj, -1, point);
            }
        }
        this.dragged.release();
        this.dragged = null;
    }

    private boolean showAmountChooser(MouseEvent mouseEvent, IEntity iEntity) {
        if ((mouseEvent.getModifiersEx() & 0x180) != 0 && iEntity instanceof StackableItem) {
            return ((StackableItem)iEntity).getQuantity() > 1;
        }
        return false;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this);
            this.point = mouseEvent2.getPoint();
            if (aWTEvent.getID() == 506) {
                this.underlyingComponent = null;
                this.requestDraw();
            } else if (mouseEvent.getID() == 502 && this.dragged != null) {
                this.underlyingComponent = null;
                this.stopDrag(mouseEvent);
                this.requestDraw();
                this.point = null;
            }
        }
    }

    private void requestDraw() {
        if (this.width != 0 && this.height != 0) {
            this.repaint(this.oldX, this.oldY, this.width, this.height);
        }
        this.oldX = this.point.x;
        this.oldY = this.point.y;
        if (this.dragged != null) {
            this.width = this.dragged.getWidth();
            this.height = this.dragged.getHeight();
            this.repaint(this.point.x, this.point.y, this.width, this.height);
        } else {
            this.width = 0;
            this.height = 0;
        }
    }

    static {
        dropForbiddenIcon = SpriteStore.get().getSprite("data/gui/forbidden.png");
    }
}

