/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui;

import games.stendhal.client.actions.SlashAction;
import games.stendhal.client.actions.SlashActionRepository;
import games.stendhal.client.gui.WindowUtils;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

class SettingsPanel
extends JButton {
    private static final int SEPARATOR_MARGIN = 8;

    SettingsPanel() {
        this.setText("Menu");
        this.setIcon(this.createArrowIcon(true));
        this.setSelectedIcon(this.createArrowIcon(false));
        this.setFocusable(false);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPopupMenu.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Column column = new Column(jPopupMenu, gridBagConstraints);
        this.createAccountsMenu(column);
        this.addSeparator(jPopupMenu, gridBagConstraints);
        column = new Column(jPopupMenu, gridBagConstraints);
        this.createToolsMenu(column);
        this.addSeparator(jPopupMenu, gridBagConstraints);
        column = new Column(jPopupMenu, gridBagConstraints);
        this.createCommandsMenu(column);
        this.addSeparator(jPopupMenu, gridBagConstraints);
        column = new Column(jPopupMenu, gridBagConstraints);
        this.createHelpMenu(column);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(SettingsPanel.this, SettingsPanel.this.getWidth() - jPopupMenu.getPreferredSize().width, SettingsPanel.this.getHeight());
            }
        });
        WindowUtils.watchFontSize(jPopupMenu);
    }

    private void addSeparator(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 0;
        JSeparator jSeparator = new JSeparator(1);
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        jComponent.add((Component)jSeparator, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
    }

    private Icon createArrowIcon(boolean bl) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Style style = StyleUtil.getStyle();
        if (style != null) {
            color4 = style.getHighLightColor();
            color3 = style.getShadowColor();
        } else {
            color4 = Color.WHITE;
            color3 = Color.BLACK;
        }
        if (bl) {
            color2 = color3;
            color = color4;
        } else {
            color2 = color4;
            color = color3;
        }
        graphics2D.setColor(color2);
        graphics2D.drawPolyline(new int[]{7, 0, 13}, new int[]{11, 4, 4}, 3);
        graphics2D.setColor(color);
        graphics2D.drawLine(7, 11, 14, 4);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private void createAccountsMenu(Column column) {
        JComponent jComponent = this.createMenuTitle("Accounts");
        column.addComponent(jComponent);
        JMenuItem jMenuItem = this.createMenuItem("Change Password", "changepassword");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Merge Accounts", "merge");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Login History", "loginhistory");
        column.addComponent(jMenuItem);
    }

    private void createToolsMenu(Column column) {
        JComponent jComponent = this.createMenuTitle("Tools");
        column.addComponent(jComponent);
        JMenuItem jMenuItem = this.createMenuItem("Take Screenshot", "takescreenshot");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Settings", "settings");
        column.addComponent(jMenuItem);
    }

    private void createCommandsMenu(Column column) {
        JComponent jComponent = this.createMenuTitle("Commands");
        column.addComponent(jComponent);
        JMenuItem jMenuItem = this.createMenuItem("Atlas", "atlas");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Online Players", "who");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Hall of Fame", "halloffame");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Travel Log", "travellog");
        column.addComponent(jMenuItem);
    }

    private void createHelpMenu(Column column) {
        JComponent jComponent = this.createMenuTitle("Help");
        column.addComponent(jComponent);
        JMenuItem jMenuItem = this.createMenuItem("Manual", "manual");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("FAQ", "faq");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Beginners Guide", "beginnersguide");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Commands", "help");
        column.addComponent(jMenuItem);
        jMenuItem = this.createMenuItem("Rules", "rules");
        column.addComponent(jMenuItem);
    }

    private JComponent createMenuTitle(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 4, 10, 0));
        return jLabel;
    }

    private JMenuItem createMenuItem(String string, String string2) {
        VariableWidthMenuItem variableWidthMenuItem = new VariableWidthMenuItem(string);
        variableWidthMenuItem.addActionListener(new CommandActionListener(string2));
        variableWidthMenuItem.setBorder(null);
        return variableWidthMenuItem;
    }

    private static class Column {
        final JComponent container;
        final GridBagConstraints c;

        Column(JComponent jComponent, GridBagConstraints gridBagConstraints) {
            this.container = jComponent;
            this.c = gridBagConstraints;
            gridBagConstraints.gridy = 0;
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 1;
        }

        void addComponent(JComponent jComponent) {
            this.container.add((Component)jComponent, this.c);
            ++this.c.gridy;
        }
    }

    private static class VariableWidthMenuItem
    extends JMenuItem {
        Dimension pref = super.getPreferredSize();

        VariableWidthMenuItem(String string) {
            super(string);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.pref;
        }
    }

    private static class CommandActionListener
    implements ActionListener {
        private final SlashAction action;

        public CommandActionListener(String string) {
            this.action = SlashActionRepository.get(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.execute(null, null);
        }
    }
}

