/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.admin;

import games.stendhal.client.gui.chatlog.HeaderLessEventLine;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.wt.core.WtWindowManager;
import games.stendhal.common.NotificationType;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class TransitionDiagram {
    private static final Logger logger = Logger.getLogger(TransitionDiagram.class);

    public void showTransitionDiagram(String string) {
        this.showTransitionDiagram(string, null);
    }

    private void showTransitionDiagram(String string, Frame frame) {
        try {
            File file = File.createTempFile("stendhal-graph-data", ".txt");
            File file2 = File.createTempFile("stendhal-graph", ".png");
            PrintStream printStream = new PrintStream(file, "UTF-8");
            printStream.print(string);
            printStream.close();
            String string2 = WtWindowManager.getInstance().getProperty("dot", "dot");
            if (string2 == null) {
                string2 = "dot";
            }
            Process process = Runtime.getRuntime().exec(string2 + " -Tpng -o " + file2.getAbsolutePath() + " " + file.getAbsolutePath());
            process.waitFor();
            JDialog jDialog = new JDialog(frame, "NPC Transition Viewer", false);
            Image image = Toolkit.getDefaultToolkit().createImage(file2.toURI().toURL());
            System.out.println("Checking image with size " + image.getWidth(jDialog) + "x" + image.getHeight(jDialog));
            ImageIcon imageIcon = new ImageIcon(image);
            JLabel jLabel = new JLabel(this.scale(imageIcon));
            jDialog.add(jLabel);
            jDialog.setDefaultCloseOperation(2);
            jDialog.pack();
            jDialog.setVisible(true);
            file2.deleteOnExit();
            file.deleteOnExit();
        }
        catch (Exception exception) {
            logger.error((Object)"Failed creating graph: ", (Throwable)exception);
            j2DClient.get().addEventLine(new HeaderLessEventLine("Failed creating graph (Is graphviz installed and on your system search path?): " + exception.getMessage(), NotificationType.ERROR));
        }
    }

    public static void main(String[] stringArray) {
        TransitionDiagram transitionDiagram = new TransitionDiagram();
        transitionDiagram.showTransitionDiagram("digraph finite_state_machine {\nrankdir=LR\nIDLE -> ATTENDING [ label = \"hi\" ];\nIDLE -> ATTENDING [ label = \"hello\" ];\nIDLE -> ATTENDING [ label = \"greetings\" ];\nIDLE -> ATTENDING [ label = \"hola\" ];\nATTENDING -> ATTENDING [ label = \"job\" ];\nHEAL_OFFERED -> ATTENDING [ label = \"yes *\" ];\nHEAL_OFFERED -> ATTENDING [ label = \"ok *\" ];\nHEAL_OFFERED -> ATTENDING [ label = \"no\" ];\nANY -> IDLE [ label = \"bye *\" ];\nANY -> IDLE [ label = \"farewell *\" ];\nANY -> IDLE [ label = \"cya *\" ];\nANY -> IDLE [ label = \"adios *\" ];\n}");
    }

    private ImageIcon scale(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = dimension.width - 20;
        int n4 = dimension.height - 100;
        if (n >= n3 || n2 >= n4) {
            return new ImageIcon(image.getScaledInstance(n3, n4, 16));
        }
        return imageIcon;
    }
}

