/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.chattext;

import games.stendhal.client.gui.chattext.ChatTextController;
import games.stendhal.client.gui.chattext.StringPrefixFilter;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class ChatCompletionHelper
extends KeyAdapter {
    private static final Logger logger = Logger.getLogger(ChatCompletionHelper.class);
    private final ChatTextController chatController;
    private final Set<String> playersonline;
    private final Set<String> slashCommands;
    private int lastkeypressed;
    private Collection<? extends String> resultset = Collections.emptyList();
    private int currentIndex;
    private String output;

    public ChatCompletionHelper(ChatTextController chatTextController, Set<String> set, Set<String> set2) {
        this.chatController = chatTextController;
        this.playersonline = set;
        this.slashCommands = new HashSet<String>(set2.size());
        for (String string : set2) {
            this.slashCommands.add("/" + string);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            if (this.lastkeypressed != 9) {
                this.currentIndex = 0;
                logger.debug((Object)("Contents of PlayerList on tab: " + this.playersonline));
                this.buildNames();
            } else {
                ++this.currentIndex;
                if (this.currentIndex == this.resultset.size()) {
                    this.currentIndex = 0;
                }
            }
            if (!this.resultset.isEmpty()) {
                this.chatController.setChatLine(this.output + this.resultset.toArray()[this.currentIndex]);
            }
        }
        this.lastkeypressed = keyEvent.getKeyCode();
    }

    private void buildNames() {
        String[] stringArray = this.chatController.getText().split("\\s+");
        String string = stringArray[stringArray.length - 1];
        Set<String> set = this.playersonline;
        if (stringArray.length == 1 && string.startsWith("/") && !string.startsWith("//")) {
            set = this.slashCommands;
        }
        StringPrefixFilter stringPrefixFilter = new StringPrefixFilter(string);
        this.output = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            this.output = this.output + stringArray[i] + " ";
        }
        this.resultset = stringPrefixFilter.filterCopy(set);
    }
}

