/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.group;

import games.stendhal.client.gui.group.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MemberListModel
extends AbstractListModel<Member>
implements Iterable<Member> {
    private List<Member> memberList = new ArrayList<Member>();
    private Map<String, Member> memberMap = new HashMap<String, Member>();
    private final MemberListHealthListener healthListener = new MemberListHealthListener();

    MemberListModel() {
    }

    @Override
    public Member getElementAt(int n) {
        return this.memberList.get(n);
    }

    @Override
    public int getSize() {
        return this.memberList.size();
    }

    void setLeader(String string) {
        Member member = this.memberMap.get(string);
        int n = this.memberList.indexOf(member);
        boolean bl = member.setLeader(true);
        if (bl) {
            for (Member member2 : this.memberList) {
                if (!member2.isLeader() || member2.getName().equals(member.getName())) continue;
                member2.setLeader(false);
                break;
            }
            Collections.sort(this.memberList);
            int n2 = this.memberList.indexOf(member);
            this.fireContentsChanged(this, n, n2);
        }
    }

    void setMembers(List<String> list) {
        if (list == null) {
            int n = this.memberList.size();
            this.memberMap.clear();
            this.memberList.clear();
            if (n > 0) {
                this.fireIntervalRemoved(this, 0, n - 1);
            }
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.removeAll(this.memberMap.keySet());
        this.addMembers(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>(this.memberMap.keySet());
        arrayList2.removeAll(list);
        this.removeMembers(arrayList2);
    }

    private void addMembers(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = -1;
        int n2 = -1;
        for (String string : list) {
            Member member = new Member(string);
            member.setChangeListener(this.healthListener);
            this.memberMap.put(string, member);
            this.memberList.add(member);
            int n3 = this.memberList.indexOf(member);
            if (n == -1) {
                n = n3;
                n2 = n3;
                continue;
            }
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        this.fireIntervalAdded(this, n, n2);
    }

    private void removeMembers(List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        int n = -1;
        int n2 = -1;
        for (String string : list) {
            Member member = this.memberMap.remove(string);
            int n3 = this.memberList.indexOf(member);
            this.memberList.remove(n3);
            if (n == -1) {
                n = n3;
                n2 = n3;
                continue;
            }
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        this.fireIntervalRemoved(this, n, n2);
    }

    void memberChanged(Member member) {
        int n = this.memberList.indexOf(member);
        if (n != -1) {
            this.fireContentsChanged(this, n, n);
        }
    }

    Member getMember(String string) {
        return this.memberMap.get(string);
    }

    @Override
    public Iterator<Member> iterator() {
        return this.memberList.iterator();
    }

    private class MemberListHealthListener
    implements ChangeListener {
        private MemberListHealthListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            final Object object = changeEvent.getSource();
            if (object instanceof Member && !SwingUtilities.isEventDispatchThread()) {
                MemberListModel.this.memberChanged((Member)object);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MemberListModel.this.memberChanged((Member)object);
                    }
                });
            }
        }
    }
}

