/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.entity.Inspector;
import games.stendhal.client.entity.Item;
import games.stendhal.client.gui.InternalWindow;
import games.stendhal.client.gui.SlotWindow;
import games.stendhal.client.gui.j2d.entity.Entity2DView;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;
import games.stendhal.common.MathHelper;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPSlot;
import org.apache.log4j.Logger;

class Item2DView<T extends Item>
extends Entity2DView<T> {
    private static final Logger logger = Logger.getLogger(Item2DView.class);
    private static final int DEFAULT_SLOT_SIZE = 8;
    private volatile SlotWindow slotWindow;
    private int slotWindowWidth;
    private int slotWindowHeight;

    Item2DView() {
    }

    @Override
    protected void buildRepresentation(T t) {
        Sprite sprite;
        SpriteStore spriteStore = SpriteStore.get();
        if (!this.isContained()) {
            ZoneInfo zoneInfo = ZoneInfo.get();
            sprite = spriteStore.getModifiedSprite(this.translate(this.getClassResourcePath()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        } else {
            sprite = spriteStore.getSprite(this.translate(this.getClassResourcePath()));
        }
        int n = sprite.getWidth();
        if (n > 32) {
            sprite = spriteStore.getAnimatedSprite(sprite, 100);
        } else if (sprite.getHeight() > 32) {
            sprite = spriteStore.getTile(sprite, 0, 0, 32, 32);
            logger.warn((Object)("Multi-row item image for: " + this.getClassResourcePath()));
        }
        this.setSprite(sprite);
    }

    @Override
    public int getZIndex() {
        return 7000;
    }

    @Override
    protected String translate(String string) {
        return "data/sprites/items/" + string + ".png";
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == IEntity.PROP_CLASS) {
            this.representationChanged = true;
        }
    }

    @Override
    public boolean isMovable() {
        return true;
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.USE);
    }

    @Override
    public boolean onHarmlessAction() {
        return false;
    }

    @Override
    public void setInspector(final Inspector inspector) {
        if (this.getContent() != null && inspector != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Item2DView.this.inspect(inspector);
                }
            });
        }
    }

    @Override
    public void onAction(ActionType actionType) {
        switch (actionType) {
            case USE: {
                if (this.isReleased() && ((Item)this.entity).isOnGround()) break;
                actionType.send(actionType.fillTargetInfo(this.entity));
                break;
            }
            default: {
                super.onAction(actionType);
            }
        }
    }

    private void inspect(Inspector inspector) {
        SlotWindow slotWindow;
        int n;
        RPSlot rPSlot = this.getContent();
        if (this.slotWindowWidth == 0) {
            n = this.getSlotCapacity(rPSlot);
            this.calculateWindowProportions(n);
        }
        n = this.slotWindow == null ? 1 : 0;
        this.slotWindow = slotWindow = inspector.inspectMe(this.entity, rPSlot, this.slotWindow, this.slotWindowWidth, this.slotWindowHeight);
        if (slotWindow != null) {
            slotWindow.setCloseable(false);
            if (n != 0) {
                slotWindow.addCloseListener(new InternalWindow.CloseListener(){

                    @Override
                    public void windowClosed(InternalWindow internalWindow) {
                        Item2DView.this.slotWindow = null;
                    }
                });
            }
            if (this.isReleased()) {
                slotWindow.close();
            }
        }
    }

    private int getSlotCapacity(RPSlot rPSlot) {
        RPObject rPObject = ((Item)this.entity).getRPObject();
        if (rPObject.has("slot_size")) {
            return MathHelper.parseIntDefault(rPObject.get("slot_size"), 8);
        }
        logger.warn((Object)("Container is missing slot size: " + rPObject));
        return rPSlot.getCapacity();
    }

    private RPSlot getContent() {
        return ((Item)this.entity).getContent();
    }

    private void calculateWindowProportions(int n) {
        int n2 = (int)Math.sqrt(n);
        while (n % n2 != 0) {
            if (--n2 > 0) continue;
            logger.error((Object)("Failed to decide dimensions for slot window. slots = " + n));
            n2 = 1;
        }
        this.slotWindowWidth = n2;
        this.slotWindowHeight = n / n2;
    }

    @Override
    public void release() {
        final SlotWindow slotWindow = this.slotWindow;
        if (slotWindow != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    slotWindow.close();
                }
            });
        }
        super.release();
    }

    @Override
    public StendhalCursor getCursor() {
        return StendhalCursor.NORMAL;
    }
}

