/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.j2d.entity;

import games.stendhal.client.ZoneInfo;
import games.stendhal.client.entity.ActionType;
import games.stendhal.client.entity.Ring;
import games.stendhal.client.gui.j2d.entity.Item2DView;
import games.stendhal.client.sprite.Sprite;
import games.stendhal.client.sprite.SpriteStore;

class Ring2DView
extends Item2DView<Ring> {
    private Sprite working;
    private Sprite broken;
    private volatile boolean stateChanged = false;

    @Override
    public void initialize(Ring ring) {
        super.initialize(ring);
        this.setSprite(this.getStateSprite());
    }

    @Override
    protected void buildRepresentation(Ring ring) {
        Sprite sprite;
        SpriteStore spriteStore = SpriteStore.get();
        if (this.isContained()) {
            sprite = spriteStore.getSprite(this.translate(this.getClassResourcePath()));
        } else {
            ZoneInfo zoneInfo = ZoneInfo.get();
            sprite = spriteStore.getModifiedSprite(this.translate(this.getClassResourcePath()), zoneInfo.getZoneColor(), zoneInfo.getColorMethod());
        }
        this.working = spriteStore.getTile(sprite, 0, 0, 32, 32);
        this.broken = spriteStore.getTile(sprite, 0, 32, 32, 32);
        this.setSprite(this.getStateSprite());
        this.stateChanged = false;
    }

    private Sprite getStateSprite() {
        if (((Ring)this.entity).isWorking()) {
            return this.working;
        }
        return this.broken;
    }

    @Override
    public int getZIndex() {
        return 5000;
    }

    @Override
    protected void update() {
        super.update();
        if (this.stateChanged) {
            this.stateChanged = false;
            this.setSprite(this.getStateSprite());
        }
    }

    @Override
    void entityChanged(Object object) {
        super.entityChanged(object);
        if (object == Ring.PROP_WORKING) {
            this.stateChanged = true;
        }
    }

    @Override
    public void onAction() {
        this.onAction(ActionType.LOOK);
    }
}

