/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.spellcasting;

import games.stendhal.client.IGameScreen;
import games.stendhal.client.actions.CastSpellAction;
import games.stendhal.client.gui.GroundContainer;
import games.stendhal.client.gui.j2d.entity.EntityView;
import games.stendhal.client.gui.spellcasting.DefaultGroundContainerMouseState;
import games.stendhal.client.gui.spellcasting.GroundContainerMouseState;
import games.stendhal.client.gui.styled.cursor.StendhalCursor;
import java.awt.Point;
import java.awt.geom.Point2D;
import marauroa.common.game.RPObject;

public class SpellCastingGroundContainerMouseState
extends GroundContainerMouseState {
    private RPObject spell;

    public SpellCastingGroundContainerMouseState(GroundContainer groundContainer) {
        super(groundContainer);
    }

    @Override
    public void switchState() {
        this.ground.setNewMouseHandlerState(new DefaultGroundContainerMouseState(this.ground));
    }

    @Override
    protected boolean onMouseClick(Point point) {
        double d;
        Point2D point2D;
        double d2;
        IGameScreen iGameScreen = this.ground.getScreen();
        EntityView<?> entityView = iGameScreen.getEntityViewAt(d2 = (point2D = iGameScreen.convertScreenViewToWorld(point)).getX(), d = point2D.getY());
        if (entityView == null) {
            entityView = iGameScreen.getMovableEntityViewAt(d2, d);
        }
        if (entityView != null) {
            String[] stringArray = new String[]{String.valueOf(this.spell.getID().getObjectID()), String.valueOf(entityView.getEntity().getID().getObjectID())};
            new CastSpellAction().execute(stringArray, null);
            this.switchState();
        }
        return true;
    }

    @Override
    protected boolean onMouseDoubleClick(Point point) {
        this.switchState();
        return false;
    }

    @Override
    protected void onMouseRightClick(Point point) {
        this.switchState();
    }

    @Override
    protected void onDragStart(Point point) {
        this.switchState();
    }

    public void setSpell(RPObject rPObject) {
        this.spell = rPObject;
    }

    @Override
    public StendhalCursor getCursor(Point point) {
        Point2D point2D = this.ground.getScreen().convertScreenViewToWorld(point);
        EntityView<?> entityView = this.ground.getScreen().getEntityViewAt(point2D.getX(), point2D.getY());
        if (entityView != null) {
            return StendhalCursor.SPELLCASTING;
        }
        return StendhalCursor.NORMAL;
    }
}

