/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.stats;

import games.stendhal.client.entity.StatusID;
import games.stendhal.client.gui.layout.SBoxLayout;
import games.stendhal.client.gui.layout.SLayout;
import games.stendhal.client.gui.stats.KarmaIndicator;
import games.stendhal.client.gui.stats.ManaIndicator;
import games.stendhal.client.gui.stats.StatusIconPanel;
import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import games.stendhal.common.constants.Testing;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class StatsPanel
extends JPanel {
    private static final long serialVersionUID = -353271026575752035L;
    private final StatLabel hpLabel;
    private final StatLabel atkLabel;
    private final StatLabel defLabel;
    private final StatLabel ratkLabel;
    private final StatLabel xpLabel;
    private final StatLabel levelLabel;
    private final StatLabel moneyLabel;
    private final StatusIconPanel statusIcons;
    private final KarmaIndicator karmaIndicator;
    private final ManaIndicator manaIndicator;

    StatsPanel() {
        this.setLayout(new SBoxLayout(false));
        this.statusIcons = new StatusIconPanel();
        this.add(this.statusIcons);
        this.karmaIndicator = KarmaIndicator.create();
        this.karmaIndicator.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add((Component)this.karmaIndicator, (Object)SLayout.EXPAND_X);
        this.manaIndicator = ManaIndicator.create();
        this.manaIndicator.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.manaIndicator.setToolTipText("Mana");
        this.add((Component)this.manaIndicator, (Object)SLayout.EXPAND_X);
        this.hpLabel = new StatLabel();
        this.add((Component)this.hpLabel, (Object)SLayout.EXPAND_X);
        this.atkLabel = new StatLabel();
        this.add((Component)this.atkLabel, (Object)SLayout.EXPAND_X);
        this.defLabel = new StatLabel();
        this.add((Component)this.defLabel, (Object)SLayout.EXPAND_X);
        if (Testing.COMBAT) {
            this.ratkLabel = new StatLabel();
            this.add((Component)this.ratkLabel, (Object)SLayout.EXPAND_X);
        } else {
            this.ratkLabel = null;
        }
        this.xpLabel = new StatLabel();
        this.add((Component)this.xpLabel, (Object)SLayout.EXPAND_X);
        this.levelLabel = new StatLabel();
        this.add((Component)this.levelLabel, (Object)SLayout.EXPAND_X);
        this.moneyLabel = new StatLabel();
        this.add((Component)this.moneyLabel, (Object)SLayout.EXPAND_X);
    }

    void setHP(String string) {
        this.hpLabel.setText(string);
    }

    void setAtk(String string) {
        this.atkLabel.setText(string);
    }

    void setDef(String string) {
        this.defLabel.setText(string);
    }

    void setRatk(String string) {
        this.ratkLabel.setText(string);
    }

    void setXP(String string) {
        this.xpLabel.setText(string);
    }

    void setKarma(double d) {
        this.karmaIndicator.setValue(d);
    }

    void setMana(double d) {
        this.manaIndicator.setMana(d);
    }

    void setBaseMana(double d) {
        this.manaIndicator.setBaseMana(d);
    }

    void setLevel(String string) {
        this.levelLabel.setText(string);
    }

    void setMoney(String string) {
        this.moneyLabel.setText(string);
    }

    void setEating(boolean bl) {
        this.statusIcons.setEating(bl);
    }

    void setChoking(boolean bl) {
        this.statusIcons.setChoking(bl);
    }

    void setStatus(StatusID statusID, boolean bl) {
        this.statusIcons.setStatus(statusID, bl);
    }

    void setAway(String string) {
        this.statusIcons.setAway(string);
    }

    void setGrumpy(String string) {
        this.statusIcons.setGrumpy(string);
    }

    private static class StatLabel
    extends JTextArea {
        public StatLabel() {
            this.setOpaque(false);
            this.setEditable(false);
            this.setFocusable(false);
            this.setWrapStyleWord(true);
            this.setLineWrap(true);
            Style style = StyleUtil.getStyle();
            if (style != null) {
                this.setForeground(style.getForeground());
            }
        }
    }
}

