/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.sprite.Sprite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;

public class PixmapBorder
implements Border {
    private static final int WIDTH = 2;
    private static final int NARROW_WIDTH = 1;
    private static final Insets insets = new Insets(2, 2, 2, 2);
    private static final Insets smallInsets = new Insets(1, 1, 1, 1);
    private final Image topLeftImage;
    private final Image bottomRightImage;
    private final int imageWidth;
    private final int imageHeight;

    public PixmapBorder(Sprite sprite, boolean bl) {
        if (bl) {
            this.bottomRightImage = this.makeModifiedImage(sprite, Color.BLACK);
            this.topLeftImage = this.makeModifiedImage(sprite, Color.WHITE);
        } else {
            this.bottomRightImage = this.makeModifiedImage(sprite, Color.WHITE);
            this.topLeftImage = this.makeModifiedImage(sprite, Color.BLACK);
        }
        this.imageWidth = sprite.getWidth();
        this.imageHeight = sprite.getHeight();
    }

    private Image makeModifiedImage(Sprite sprite, Color color) {
        int n = sprite.getWidth();
        int n2 = sprite.getHeight();
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        sprite.draw(graphics2D, 0, 0);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (component instanceof JPopupMenu) {
            return smallInsets;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        Rectangle rectangle = graphics.getClipBounds();
        Graphics graphics2 = graphics.create();
        int n8 = this.getBorderWidth(component);
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2);
        polygon.addPoint(n + n3, n2);
        polygon.addPoint(n + n3 - n8, n2 + n8);
        polygon.addPoint(n + n8, n2 + n8);
        polygon.addPoint(n + n8, n2 + n4 - n8);
        polygon.addPoint(n, n2 + n4);
        graphics2.setClip(polygon);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        for (n7 = n; n7 < n + n3; n7 += this.imageWidth) {
            graphics2.drawImage(this.topLeftImage, n7, n2, null);
        }
        for (n7 = n2; n7 < n2 + n4; n7 += this.imageHeight) {
            graphics2.drawImage(this.topLeftImage, n, n7, null);
        }
        polygon.reset();
        polygon.addPoint(n + n3, n2);
        polygon.addPoint(n + n3, n2 + n4);
        polygon.addPoint(n, n2 + n4);
        polygon.addPoint(n + n8, n2 + n4 - n8);
        polygon.addPoint(n + n3 - n8, n2 + n4 - n8);
        polygon.addPoint(n + n3 - n8, n2 + n8);
        graphics2.setClip(polygon);
        graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        n7 = n2 + n4 - n8 - (n4 - n8) % this.imageHeight;
        int n9 = n2 + n4 - n4 % this.imageHeight;
        for (n6 = n7; n6 <= n9; n6 += this.imageHeight) {
            for (n5 = n; n5 < n + n3; n5 += this.imageWidth) {
                graphics2.drawImage(this.bottomRightImage, n5, n6, null);
            }
        }
        n6 = n + n3 - n8 - (n3 - n8) % this.imageWidth;
        n5 = n + n3 - n3 % this.imageWidth;
        for (int i = n6; i <= n5; i += this.imageWidth) {
            for (int j = n2; j < n2 + n4; j += this.imageHeight) {
                graphics2.drawImage(this.bottomRightImage, i, j, null);
            }
        }
        graphics2.dispose();
    }

    private int getBorderWidth(Component component) {
        if (component instanceof JMenuItem || component instanceof JPopupMenu) {
            return 1;
        }
        return 2;
    }
}

