/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class StyledOptionPaneUI
extends BasicOptionPaneUI {
    private final Style style;
    private boolean cleaned;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledOptionPaneUI(StyleUtil.getStyle());
    }

    public StyledOptionPaneUI(Style style) {
        this.style = style;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.cleaned) {
            this.cleanComponents(jComponent);
            jComponent.setOpaque(false);
            Container container = jComponent.getParent();
            if (container instanceof JComponent) {
                ((JComponent)container).setOpaque(false);
                ((JComponent)container).setBackground(this.style.getPlainColor());
            }
            this.cleaned = true;
        }
    }

    private void cleanComponents(Component component) {
        if (component instanceof Container) {
            if (component instanceof JPanel) {
                ((JPanel)component).setBorder(null);
            } else if (component instanceof JLabel) {
                component.setForeground(this.style.getForeground());
            }
            for (Component component2 : ((Container)component).getComponents()) {
                this.cleanComponents(component2);
            }
        }
    }

    @Override
    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object instanceof String) {
            JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setEditable(false);
            jTextArea.setBorder(null);
            jTextArea.setOpaque(false);
            jTextArea.setForeground(this.style.getForeground());
            jTextArea.setFont(UIManager.getFont("Label.font"));
            object = jTextArea;
        }
        super.addMessageComponents(container, gridBagConstraints, object, n, bl);
    }
}

