/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Container;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class StyledPopupMenuUI
extends BasicPopupMenuUI {
    private static StyledPopupMenuUI instance;
    private final Style style;

    public static synchronized ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new StyledPopupMenuUI(StyleUtil.getStyle());
        }
        return instance;
    }

    public StyledPopupMenuUI(Style style) {
        this.style = style;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        StyleUtil.fillBackground(this.style, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        Popup popup = super.getPopup(jPopupMenu, n, n2);
        Container container = jPopupMenu.getParent();
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(null);
        }
        return popup;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(this.style.getBorder());
    }
}

