/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.styled;

import games.stendhal.client.gui.styled.Style;
import games.stendhal.client.gui.styled.StyleUtil;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class StyledProgressBarUI
extends BasicProgressBarUI {
    private final Style style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new StyledProgressBarUI(StyleUtil.getStyle());
    }

    public StyledProgressBarUI(Style style) {
        this.style = style;
    }

    @Override
    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        graphics.setColor(this.style.getHighLightColor());
        graphics.fillRect(0, 0, jProgressBar.getWidth(), jProgressBar.getHeight());
        Insets insets = jProgressBar.getInsets();
        int n = this.getAmountFull(insets, jProgressBar.getWidth(), jProgressBar.getHeight());
        StyleUtil.fillBackground(this.style, graphics, 0, 0, n, jProgressBar.getHeight());
        this.style.getBorder().paintBorder(jComponent, graphics, insets.left, insets.top, n, jProgressBar.getHeight() - insets.left - insets.right);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder(this.style.getBorderDown());
    }
}

