/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.textformat;

import games.stendhal.client.gui.textformat.TallyMarks;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtmlPreprocessor {
    private static final Pattern TALLY_PATTERN = Pattern.compile("(.*)\\<tally\\>([0-9]+)\\</tally\\>(.*)");

    public String preprocess(String string) {
        return this.handleTallyTag(string);
    }

    private String handleTallyTag(String string) {
        Matcher matcher = TALLY_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            String string4 = matcher.group(3);
            int n = Integer.parseInt(string3);
            return string2 + "<span style=\"font-family: 'Tally'\">" + new TallyMarks(n) + "</span>" + string4;
        }
        return string;
    }
}

