/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.gui.trade;

import games.stendhal.client.ClientSingletonRepository;
import games.stendhal.client.entity.IEntity;
import games.stendhal.client.gui.j2DClient;
import games.stendhal.client.gui.trade.TradingWindow;
import games.stendhal.common.TradeState;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import marauroa.common.game.RPAction;

public final class TradingController {
    private static TradingController instance;
    private final TradingWindow window = new TradingWindow(this);
    private IEntity tradingPartner;
    private IEntity user;
    private TradeState myState;
    private TradeState partnerState;

    private TradingController() {
    }

    public JComponent getWindow() {
        return this.window;
    }

    public void setState(IEntity iEntity, IEntity iEntity2, TradeState tradeState, TradeState tradeState2) {
        this.setMyState(tradeState);
        this.setPartner(iEntity2);
        this.setUser(iEntity);
        this.setPartnerState(tradeState2);
        if (tradeState != TradeState.NO_ACTIVE_TRADE) {
            if (tradeState == TradeState.TRADE_COMPLETED) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.close();
                    }
                });
            } else if (this.window.getParent() == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        j2DClient.get().addWindow(TradingController.this.window);
                        TradingController.this.window.setVisible(true);
                    }
                });
            }
        }
    }

    private void setPartner(final IEntity iEntity) {
        if (iEntity != this.tradingPartner) {
            this.tradingPartner = iEntity;
            if (iEntity != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.setPartnerSlot(iEntity, "trade");
                        TradingController.this.window.setPartnerName(iEntity.getName());
                    }
                });
            }
        }
    }

    private void setUser(final IEntity iEntity) {
        if (this.user != iEntity) {
            this.user = iEntity;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TradingController.this.window.setUserSlot(iEntity, "trade");
                }
            });
        }
    }

    private void setMyState(TradeState tradeState) {
        if (this.myState != tradeState) {
            this.myState = tradeState;
            this.onMyStateChanged();
        }
    }

    private void setPartnerState(TradeState tradeState) {
        if (this.partnerState != tradeState) {
            this.partnerState = tradeState;
            this.onPartnerStateChanged();
        }
    }

    private void onMyStateChanged() {
        Runnable runnable = null;
        switch (this.myState) {
            case NO_ACTIVE_TRADE: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.disableAll();
                        if (TradingController.this.window.isShowing()) {
                            TradingController.this.window.setPartnerSlot(TradingController.this.user, "trade");
                        }
                    }
                };
                break;
            }
            case MAKING_OFFERS: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(false);
                        TradingController.this.window.allowOffer(true);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setUserStatus(TradingController.this.myState);
                    }
                };
                break;
            }
            case LOCKED: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(TradingController.this.partnerState == TradeState.LOCKED);
                        TradingController.this.window.allowOffer(false);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setUserStatus(TradingController.this.myState);
                    }
                };
                break;
            }
            case DEAL_WAITING_FOR_OTHER_DEAL: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(false);
                        TradingController.this.window.allowOffer(false);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setPartnerStatus(TradingController.this.myState);
                    }
                };
                break;
            }
        }
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void onPartnerStateChanged() {
        Runnable runnable = null;
        switch (this.partnerState) {
            case MAKING_OFFERS: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(false);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setPartnerStatus(TradingController.this.partnerState);
                    }
                };
                break;
            }
            case LOCKED: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(TradingController.this.myState == TradeState.LOCKED);
                        TradingController.this.window.allowOffer(TradingController.this.myState != TradeState.LOCKED);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setPartnerStatus(TradingController.this.partnerState);
                    }
                };
                break;
            }
            case DEAL_WAITING_FOR_OTHER_DEAL: {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        TradingController.this.window.allowAccept(true);
                        TradingController.this.window.allowOffer(false);
                        TradingController.this.window.allowCancel(true);
                        TradingController.this.window.setUserStatus(TradingController.this.partnerState);
                    }
                };
                break;
            }
        }
        if (runnable != null) {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static synchronized TradingController get() {
        if (instance == null) {
            instance = new TradingController();
        }
        return instance;
    }

    private RPAction makeAction() {
        RPAction rPAction = new RPAction();
        rPAction.put("type", "trade");
        return rPAction;
    }

    void cancelTrade() {
        RPAction rPAction = this.makeAction();
        rPAction.put("action", "cancel");
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }

    void lockTrade() {
        RPAction rPAction = this.makeAction();
        rPAction.put("action", "lock");
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }

    void acceptTrade() {
        RPAction rPAction = this.makeAction();
        rPAction.put("action", "deal");
        ClientSingletonRepository.getClientFramework().send(rPAction);
    }
}

