/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.facade;

import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.common.math.Algebra;
import games.stendhal.common.math.Geometry;
import java.util.Arrays;

public class AudibleCircleArea
implements AudibleArea {
    private final float[] mCenter;
    private float mInnerRadius;
    private float mOuterRadius;

    public AudibleCircleArea(float[] fArray, float f, float f2) {
        this.mCenter = new float[fArray.length];
        System.arraycopy(fArray, 0, this.mCenter, 0, fArray.length);
        this.mInnerRadius = f;
        this.mOuterRadius = f2;
    }

    public void setArea(float f, float f2) {
        this.mInnerRadius = f;
        this.mOuterRadius = f2;
    }

    public void setPosition(float[] fArray) {
        Algebra.mov_Vecf(this.mCenter, fArray);
    }

    public void getPosition(float[] fArray) {
        Algebra.mov_Vecf(fArray, this.mCenter);
    }

    public float getInnerRadius() {
        return this.mInnerRadius;
    }

    public float getOuterRadius() {
        return this.mOuterRadius;
    }

    @Override
    public float getHearingIntensity(float[] fArray) {
        float f = Algebra.distanceSqrt_Vecf(fArray, this.mCenter);
        if (f > this.mOuterRadius * this.mOuterRadius) {
            return 0.0f;
        }
        if (f < this.mInnerRadius * this.mInnerRadius) {
            return 1.0f;
        }
        f = (float)Math.sqrt(f) - this.mInnerRadius;
        return 1.0f - f / (this.mOuterRadius - this.mInnerRadius);
    }

    @Override
    public void getClosestPoint(float[] fArray, float[] fArray2) {
        Geometry.closestPoint_SpherePointf(fArray, this.mCenter, this.mInnerRadius, fArray2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AudibleCircleArea [mCenter=");
        stringBuilder.append(Arrays.toString(this.mCenter));
        stringBuilder.append(", mInnerRadius=" + this.mInnerRadius);
        stringBuilder.append(", mOuterRadius=");
        stringBuilder.append(this.mOuterRadius + "]");
        return stringBuilder.toString();
    }
}

