/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.manager;

import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.manager.AudioResource;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.client.sound.system.processors.OggVorbisDecoder;
import games.stendhal.client.sound.system.processors.PCMStreamConverter;
import games.stendhal.client.sound.system.processors.Recorder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundFile
extends SignalProcessor
implements Cloneable {
    private int mNumChannels;
    private int mSampleRate;
    private SignalProcessor mGenerator = null;
    private Recorder mRecorder = null;
    private final AudioResource mAudioResource;
    private final boolean mEnableStreaming;
    private final int mOutputNumSamples;
    private final SoundFileType mFileType;
    private final SignalProcessor mPropagator = new SignalProcessor(){

        @Override
        protected void modify(float[] fArray, int n, int n2, int n3) {
            SoundFile.this.propagate(fArray, n, n2, n3);
        }

        @Override
        protected void finished() {
            SoundFile.this.quit();
        }
    };

    public SoundFile(AudioResource audioResource, SoundFileType soundFileType, int n, boolean bl) throws IOException {
        InputStream inputStream = audioResource.getInputStream();
        if (inputStream == null) {
            throw new IOException("audio AudioResource doesn't exist: " + audioResource.getName());
        }
        this.mAudioResource = audioResource;
        this.mFileType = soundFileType;
        this.mEnableStreaming = bl;
        this.mOutputNumSamples = n;
        SignalProcessor signalProcessor = this.chooseDecoder(inputStream, soundFileType, n);
        if (signalProcessor == null) {
            throw new IOException("could not load audio AudioResource: " + audioResource.getName());
        }
        if (bl) {
            signalProcessor.connectTo(this.mPropagator, true);
            this.mGenerator = signalProcessor;
        } else {
            this.mRecorder = new Recorder();
            this.mRecorder.connectTo(signalProcessor, false);
            while (this.mRecorder.request()) {
            }
            this.mRecorder.disconnect();
            this.mRecorder.trim();
            Recorder.Player player = this.mRecorder.createPlayer(n);
            player.connectTo(this.mPropagator, true);
            this.mGenerator = player;
        }
    }

    private SoundFile(Recorder recorder, AudioResource audioResource, SoundFileType soundFileType, int n) {
        this.mAudioResource = audioResource;
        this.mFileType = soundFileType;
        this.mOutputNumSamples = n;
        this.mEnableStreaming = false;
        this.mRecorder = recorder;
        this.mGenerator = recorder.createPlayer(n);
        this.mGenerator.connectTo(this.mPropagator, true);
    }

    public int getNumChannels() {
        return this.mNumChannels;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public void close() {
        if (this.mGenerator instanceof Recorder.Player) {
            this.mRecorder.clear();
        } else if (this.mGenerator instanceof OggVorbisDecoder) {
            OggVorbisDecoder oggVorbisDecoder = (OggVorbisDecoder)this.mGenerator;
            oggVorbisDecoder.close();
        } else if (this.mGenerator instanceof PCMStreamConverter) {
            PCMStreamConverter pCMStreamConverter = (PCMStreamConverter)this.mGenerator;
            pCMStreamConverter.close();
        }
    }

    public SoundFile clone() {
        SoundFile soundFile;
        block4: {
            soundFile = null;
            if (this.mGenerator instanceof Recorder.Player) {
                soundFile = new SoundFile(this.mRecorder, this.mAudioResource, this.mFileType, this.mOutputNumSamples);
            } else {
                try {
                    soundFile = new SoundFile(this.mAudioResource, this.mFileType, this.mOutputNumSamples, this.mEnableStreaming);
                }
                catch (IOException iOException) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)("catched exception - " + iOException));
                }
            }
        }
        return soundFile;
    }

    public void restart() {
        if (this.mGenerator instanceof OggVorbisDecoder) {
            OggVorbisDecoder oggVorbisDecoder = (OggVorbisDecoder)this.mGenerator;
            oggVorbisDecoder.close();
            try {
                oggVorbisDecoder.open(this.mAudioResource.getInputStream(), 256, this.mOutputNumSamples);
            }
            catch (IOException iOException) {}
        } else if (this.mGenerator instanceof PCMStreamConverter) {
            PCMStreamConverter pCMStreamConverter = (PCMStreamConverter)this.mGenerator;
            pCMStreamConverter.close();
            try {
                AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(this.mAudioResource.getInputStream());
                pCMStreamConverter.open(audioInputStream, audioInputStream.getFormat(), this.mOutputNumSamples);
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {}
        } else if (this.mGenerator instanceof Recorder.Player) {
            Recorder.Player player = (Recorder.Player)this.mGenerator;
            player.restart();
        }
    }

    private SignalProcessor chooseDecoder(InputStream inputStream, SoundFileType soundFileType, int n) {
        SignalProcessor signalProcessor = null;
        switch (soundFileType) {
            case OGG: {
                try {
                    if (inputStream == null) break;
                    OggVorbisDecoder oggVorbisDecoder = new OggVorbisDecoder(inputStream, 256, n);
                    this.mNumChannels = oggVorbisDecoder.getNumChannels();
                    this.mSampleRate = oggVorbisDecoder.getSampleRate();
                    signalProcessor = oggVorbisDecoder;
                }
                catch (Exception exception) {
                    signalProcessor = null;
                }
                break;
            }
            case WAV: {
                try {
                    AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(inputStream));
                    signalProcessor = new PCMStreamConverter(inputStream, audioInputStream.getFormat(), n);
                    this.mNumChannels = audioInputStream.getFormat().getChannels();
                    this.mSampleRate = (int)audioInputStream.getFormat().getSampleRate();
                    break;
                }
                catch (Exception exception) {
                    signalProcessor = null;
                }
            }
        }
        return signalProcessor;
    }

    @Override
    protected boolean generate() {
        return this.mPropagator.request();
    }
}

