/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.manager;

import games.stendhal.client.sound.facade.AudibleArea;
import games.stendhal.client.sound.facade.InfiniteAudibleArea;
import games.stendhal.client.sound.facade.SoundFileType;
import games.stendhal.client.sound.facade.SoundHandle;
import games.stendhal.client.sound.facade.Time;
import games.stendhal.client.sound.manager.AudioResource;
import games.stendhal.client.sound.manager.DeviceEvaluator;
import games.stendhal.client.sound.manager.SoundFile;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.client.sound.system.SoundSystemNG;
import games.stendhal.client.sound.system.processors.DirectedSound;
import games.stendhal.client.sound.system.processors.Interruptor;
import games.stendhal.client.sound.system.processors.VolumeAdjustor;
import games.stendhal.common.math.Algebra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.SourceDataLine;
import org.apache.log4j.Logger;

public class SoundManagerNG {
    private static final Logger logger = Logger.getLogger(SoundManagerNG.class);
    private static final int SOUND_CHANNEL_LIMIT = 50;
    private static final int DIMENSION = 2;
    private static final float[] HEARER_LOOKONG_DIRECTION = new float[]{0.0f, 1.0f};
    private static final InfiniteAudibleArea INFINITE_AUDIBLE_AREA = new InfiniteAudibleArea();
    private static final Time BUFFER_DURATION = new Time(15L, Time.Unit.MILLI);
    private static final Time ZERO_DURATION = new Time();
    private final Collection<DeviceEvaluator.Device> mDevices;
    private final AudioFormat mAudioFormat;
    private final LinkedList<SoundChannel> mChannels = new LinkedList();
    private final float[] mHearerPosition = new float[2];
    private boolean mMute = false;
    private SoundSystemNG mSoundSystem;

    protected SoundManagerNG(boolean bl, Collection<DeviceEvaluator.Device> collection, AudioFormat audioFormat) {
        Algebra.mov_Vecf(this.mHearerPosition, 0.0f);
        this.mDevices = collection;
        this.mAudioFormat = audioFormat;
        logger.info((Object)"initializing sound system");
        if (collection != null) {
            for (DeviceEvaluator.Device device : collection) {
                logger.info((Object)("available device: " + device.getName() + " - " + device.getDescription() + " (" + device.getRating() + ")"));
            }
        }
        if (bl || collection == null || collection.size() == 0) {
            this.mSoundSystem = new SoundSystemNG(this.mAudioFormat, BUFFER_DURATION);
            this.mMute = true;
        } else {
            this.mSoundSystem = new SoundSystemNG(this.getOutputLine(), BUFFER_DURATION);
            this.mMute = false;
        }
        this.startSoundsystem();
    }

    protected final void startSoundsystem() {
        this.mSoundSystem.setDaemon(true);
        this.mSoundSystem.start();
    }

    public synchronized Sound openSound(AudioResource audioResource, SoundFileType soundFileType, int n, boolean bl) {
        Sound sound = null;
        try {
            SoundFile soundFile = new SoundFile(audioResource, soundFileType, n, bl);
            sound = new Sound();
            sound.file.set(soundFile);
        }
        catch (IOException iOException) {
            logger.warn((Object)iOException);
            return null;
        }
        return sound;
    }

    public synchronized void setHearerPosition(float[] fArray) {
        Algebra.mov_Vecf(this.mHearerPosition, fArray);
    }

    public synchronized void update() {
        for (SoundChannel soundChannel : this.mChannels) {
            if (!soundChannel.isActive()) continue;
            soundChannel.update();
        }
    }

    public synchronized void play(Sound sound, float f, int n, AudibleArea audibleArea, boolean bl, Time time) {
        if (sound == null) {
            return;
        }
        if (sound.isActive()) {
            SoundChannel soundChannel = sound.channel.get();
            soundChannel.setAutoRepeat(bl);
            soundChannel.startFading(1.0f, time);
            soundChannel.setVolume(f);
            soundChannel.setLayer(n);
            soundChannel.setAudibleArea(audibleArea);
            soundChannel.resumePlayback();
            soundChannel.update();
        } else if (!this.mMute && this.mSoundSystem.isRunning()) {
            SoundChannel soundChannel = this.getInactiveChannel();
            soundChannel.setAutoRepeat(bl);
            soundChannel.setLayer(n);
            soundChannel.setAudibleArea(audibleArea);
            soundChannel.playSound(sound, f, time);
            soundChannel.update();
            this.closeInactiveChannels(50);
        }
    }

    public synchronized void stop(Sound sound, Time time) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().stopPlayback(time);
        }
    }

    public synchronized void changeVolume(Sound sound, float f) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setVolume(f);
        }
    }

    public synchronized void changeLayer(Sound sound, int n) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setLayer(n);
        }
    }

    public synchronized void changeAudibleArea(Sound sound, AudibleArea audibleArea) {
        if (sound != null && sound.isActive()) {
            sound.channel.get().setAudibleArea(audibleArea);
        }
    }

    public synchronized void mute(boolean bl, boolean bl2, Time time) {
        if (bl && !this.mMute) {
            logger.info((Object)"turning off audio");
            this.mSoundSystem.suspend(time, true);
            if (bl2) {
                for (SoundChannel soundChannel : this.mChannels) {
                    if (!soundChannel.isActive()) continue;
                    soundChannel.startFading(0.0f, time);
                }
            }
        }
        if (!bl && this.mMute) {
            logger.info((Object)"turning on audio");
            this.mSoundSystem.proceed(null, this.getOutputLine());
            if (bl2) {
                for (SoundChannel soundChannel : this.mChannels) {
                    if (!soundChannel.isActive()) continue;
                    soundChannel.startFading(time);
                }
            }
        }
        this.mMute = bl;
    }

    public synchronized Collection<Sound> getActiveSounds() {
        ArrayList<Sound> arrayList = new ArrayList<Sound>(this.mChannels.size());
        for (SoundChannel soundChannel : this.mChannels) {
            Sound sound = soundChannel.getSoundObject();
            if (sound == null || !sound.isActive()) continue;
            arrayList.add(sound);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public synchronized void exit() {
        this.mSoundSystem.exit(null);
        try {
            this.mSoundSystem.join();
        }
        catch (InterruptedException interruptedException) {
            logger.warn((Object)("joining sound system thread was interrupted: " + interruptedException));
        }
    }

    private void closeInactiveChannels(int n) {
        int n2 = this.mChannels.size();
        Iterator iterator = this.mChannels.iterator();
        while (iterator.hasNext() && this.mChannels.size() > n) {
            SoundChannel soundChannel = (SoundChannel)iterator.next();
            if (soundChannel.isActive()) continue;
            soundChannel.close();
            iterator.remove();
        }
        if ((n2 -= this.mChannels.size()) > 0) {
            logger.debug((Object)("close " + n2 + " inactive sound channels"));
        }
    }

    private SoundChannel getInactiveChannel() {
        SoundChannel soundChannel = null;
        for (SoundChannel soundChannel2 : this.mChannels) {
            if (soundChannel2.isActive()) continue;
            soundChannel = soundChannel2;
            break;
        }
        if (soundChannel == null) {
            logger.debug((Object)("open new sound channel (number " + this.mChannels.size() + ")"));
            soundChannel = new SoundChannel();
            this.mChannels.add(soundChannel);
        }
        return soundChannel;
    }

    private SourceDataLine getOutputLine() {
        for (DeviceEvaluator.Device device : this.mDevices) {
            SourceDataLine sourceDataLine = device.getLine(SourceDataLine.class, this.mAudioFormat);
            if (sourceDataLine == null) continue;
            return sourceDataLine;
        }
        return null;
    }

    public Collection<DeviceEvaluator.Device> getDevices() {
        return new LinkedList<DeviceEvaluator.Device>(this.mDevices);
    }

    private final class SoundChannel
    extends SignalProcessor {
        final float[] mSoundPosition = new float[2];
        final AtomicBoolean mAutoRepeat = new AtomicBoolean(false);
        final AtomicBoolean mIsActive = new AtomicBoolean(false);
        final AtomicReference<AudibleArea> mAudibleArea = new AtomicReference<InfiniteAudibleArea>(SoundManagerNG.access$000());
        final Interruptor mInterruptor = new Interruptor();
        final DirectedSound mDirectedSound = new DirectedSound();
        final VolumeAdjustor mGlobalVolume = new VolumeAdjustor();
        final SoundSystemNG.Output mOutput;
        Sound mSound = null;

        SoundChannel() {
            this.mOutput = SoundManagerNG.this.mSoundSystem.openOutput(0, this.mInterruptor, this, this.mGlobalVolume, this.mDirectedSound);
        }

        boolean isActive() {
            return this.mIsActive.get();
        }

        void setAutoRepeat(boolean bl) {
            this.mAutoRepeat.set(bl);
        }

        void setVolume(float f) {
            this.mGlobalVolume.setVolume(f);
        }

        void startFading(float f, Time time) {
            this.mGlobalVolume.startFading(f, time);
        }

        void startFading(Time time) {
            this.mGlobalVolume.startFading(time);
        }

        void setLayer(int n) {
        }

        void resumePlayback() {
            this.mInterruptor.play();
        }

        void close() {
            SoundManagerNG.this.mSoundSystem.closeOutput(this.mOutput);
        }

        Sound getSoundObject() {
            return this.mSound;
        }

        void setAudibleArea(AudibleArea audibleArea) {
            if (audibleArea == null) {
                audibleArea = INFINITE_AUDIBLE_AREA;
            }
            this.mAudibleArea.set(audibleArea);
        }

        synchronized void playSound(Sound sound, float f, Time time) {
            if (this.mSound != null) {
                this.mSound.file.get().disconnect();
                this.mSound.file.get().restart();
                this.mSound.channel.set(null);
                this.mOutput.setIntensity(0.0f);
            }
            if (sound != null) {
                if (time == null) {
                    time = ZERO_DURATION;
                }
                this.mInterruptor.play();
                this.mGlobalVolume.setVolume(0.0f);
                this.mGlobalVolume.startFading(f, time);
                sound.channel.set(this);
                sound.file.get().connectTo(this.mInterruptor, true);
            }
            this.mSound = sound;
            this.mIsActive.set(sound != null);
        }

        void stopPlayback(Time time) {
            if (time == null) {
                time = ZERO_DURATION;
            }
            this.mAutoRepeat.set(false);
            this.mGlobalVolume.startFading(0.0f, time);
            this.mInterruptor.stop(time);
        }

        void update() {
            float f = this.mAudibleArea.get().getHearingIntensity(SoundManagerNG.this.mHearerPosition);
            this.mAudibleArea.get().getClosestPoint(this.mSoundPosition, SoundManagerNG.this.mHearerPosition);
            this.mDirectedSound.setPositions2D(this.mSoundPosition, SoundManagerNG.this.mHearerPosition, HEARER_LOOKONG_DIRECTION, f);
            this.mOutput.setIntensity(f);
        }

        @Override
        protected void finished() {
            if (this.mAutoRepeat.get()) {
                try {
                    this.mSound.file.get().restart();
                }
                catch (NullPointerException nullPointerException) {
                    logger.error((Object)nullPointerException, (Throwable)nullPointerException);
                    logger.error((Object)("mSound: " + this.mSound));
                    logger.error((Object)("mSound.file: " + this.mSound.file));
                    logger.error((Object)("mSound.file.get: " + this.mSound.file.get()));
                }
            } else {
                this.playSound(null, 0.0f, null);
                super.quit();
            }
        }
    }

    public static final class Sound
    implements SoundHandle,
    Cloneable {
        final AtomicReference<SoundFile> file = new AtomicReference<Object>(null);
        final AtomicReference<SoundChannel> channel = new AtomicReference<Object>(null);
        Object object = null;

        public Sound clone() {
            Sound sound = new Sound();
            sound.file.set(this.file.get().clone());
            sound.object = this.object;
            return sound;
        }

        public <T> T getAttachment(Class<T> clazz) {
            if (clazz.isInstance(this.object)) {
                return (T)this.object;
            }
            return null;
        }

        public Object getAttachment() {
            return this.object;
        }

        public boolean isActive() {
            return this.channel.get() != null && this.channel.get().isActive();
        }

        public void setAttachment(Object object) {
            this.object = object;
        }
    }
}

