/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sound.system.processors;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import games.stendhal.client.sound.system.SignalProcessor;
import games.stendhal.common.memory.Field;
import java.io.IOException;
import java.io.InputStream;

public class OggVorbisDecoder
extends SignalProcessor {
    private StreamState mOggStreamState = null;
    private SyncState mOggSyncState = null;
    private DspState mVorbisDspState = null;
    private Block mVorbisBlock = null;
    private Comment mVorbisComment = null;
    private Info mVorbisInfo = null;
    private float[][][] mUniformPCMData = new float[1][][];
    int[] mPCMIndex = null;
    private float[] mOutputBuffer = null;
    private byte[] mInputBuffer = null;
    private int mInputBufferSize = 0;
    private int mReadPos = 0;
    private boolean mEndOfStream = true;
    private boolean mLastPageWasRead = false;
    private boolean mDecoderIsOpened = false;
    private InputStream mIStream = null;

    protected final void init(InputStream inputStream, int n, int n2) throws IOException {
        this.mOggStreamState = new StreamState();
        this.mOggSyncState = new SyncState();
        this.mVorbisDspState = new DspState();
        this.mVorbisBlock = new Block(this.mVorbisDspState);
        this.mVorbisComment = new Comment();
        this.mVorbisInfo = new Info();
        this.mReadPos = 0;
        this.mEndOfStream = false;
        this.mLastPageWasRead = false;
        this.mOggSyncState.init();
        this.mOggSyncState.buffer(n);
        this.mInputBuffer = this.mOggSyncState.data;
        this.mInputBufferSize = n;
        this.mIStream = inputStream;
        if (!this.readHeader()) {
            throw new IOException("could not read ogg headers");
        }
        this.mPCMIndex = Field.expand(this.mPCMIndex, this.getNumChannels(), false);
        this.mOutputBuffer = Field.expand(this.mOutputBuffer, n2 * this.getNumChannels(), false);
        this.mDecoderIsOpened = true;
    }

    protected Page readPage(boolean bl, boolean bl2) throws IOException {
        Page page = new Page();
        while (!this.mEndOfStream) {
            switch (this.mOggSyncState.pageout(page)) {
                case -1: {
                    if (!bl) {
                        return null;
                    }
                }
                case 0: {
                    int n = this.mIStream.read(this.mInputBuffer, this.mReadPos, this.mInputBufferSize);
                    if (n <= 0) {
                        this.mEndOfStream = true;
                        return null;
                    }
                    this.mOggSyncState.wrote(n);
                    break;
                }
                case 1: {
                    if (bl2 && this.mOggStreamState.pagein(page) == -1) {
                        return null;
                    }
                    if (page.eos() != 0) {
                        this.mLastPageWasRead = true;
                    }
                    return page;
                }
            }
            this.mReadPos = this.mOggSyncState.buffer(this.mInputBufferSize);
            this.mInputBuffer = this.mOggSyncState.data;
        }
        return null;
    }

    protected Packet readPacket(boolean bl) throws IOException {
        Packet packet = new Packet();
        while (true) {
            switch (this.mOggStreamState.packetout(packet)) {
                case -1: {
                    if (!bl) {
                        return null;
                    }
                }
                case 0: {
                    if (this.readPage(bl, true) != null) break;
                    return null;
                }
                case 1: {
                    return packet;
                }
            }
        }
    }

    protected boolean readHeader() throws IOException {
        Page page = this.readPage(false, false);
        if (page == null) {
            return false;
        }
        this.mOggStreamState.init(page.serialno());
        this.mOggStreamState.reset();
        this.mVorbisInfo.init();
        this.mVorbisComment.init();
        if (this.mOggStreamState.pagein(page) == -1) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            Packet packet = this.readPacket(false);
            if (packet == null) {
                return false;
            }
            if (this.mVorbisInfo.synthesis_headerin(this.mVorbisComment, packet) >= 0) continue;
            return false;
        }
        this.mVorbisDspState.synthesis_init(this.mVorbisInfo);
        this.mVorbisBlock.init(this.mVorbisDspState);
        return true;
    }

    protected int read() throws IOException {
        if (this.reachedEndOfStream()) {
            return 0;
        }
        int n = this.mOutputBuffer.length;
        int n2 = n / this.mVorbisInfo.channels;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (!this.mEndOfStream && n4 < n2) {
            if (n5 >= n3) {
                this.mVorbisDspState.synthesis_read(n3);
                n3 = this.mVorbisDspState.synthesis_pcmout(this.mUniformPCMData, this.mPCMIndex);
                n5 = 0;
                if (n3 != 0) continue;
                Packet packet = this.readPacket(true);
                if (packet == null && this.mLastPageWasRead) {
                    this.mEndOfStream = true;
                    return 0;
                }
                if (packet == null || this.mVorbisBlock.synthesis(packet) != 0) continue;
                this.mVorbisDspState.synthesis_blockin(this.mVorbisBlock);
                continue;
            }
            int n6 = n4 * this.mVorbisInfo.channels;
            for (int i = 0; i < this.mVorbisInfo.channels; ++i) {
                float f;
                this.mOutputBuffer[n6 + i] = f = this.mUniformPCMData[0][i][this.mPCMIndex[i] + n5];
            }
            ++n4;
            ++n5;
        }
        this.mVorbisDspState.synthesis_read(n5);
        return n4;
    }

    protected float[] getOutputBuffer() {
        return this.mOutputBuffer;
    }

    @Override
    protected boolean generate() {
        try {
            int n = this.read();
            if (this.reachedEndOfStream()) {
                super.quit();
                return false;
            }
            super.propagate(this.mOutputBuffer, n, this.getNumChannels(), this.getSampleRate());
        }
        catch (IOException iOException) {
            this.close();
        }
        return true;
    }

    public OggVorbisDecoder(InputStream inputStream, int n, int n2) throws IOException {
        this.init(inputStream, n, n2);
    }

    public synchronized int getNumChannels() {
        return this.mVorbisInfo.channels;
    }

    public synchronized int getSampleRate() {
        return this.mVorbisInfo.rate;
    }

    public synchronized boolean reachedEndOfStream() {
        return this.mEndOfStream;
    }

    public synchronized void open(InputStream inputStream, int n, int n2) throws IOException {
        if (!this.mDecoderIsOpened) {
            this.init(inputStream, n, n2);
        }
    }

    public synchronized void close() {
        block2: {
            this.mOggStreamState.clear();
            this.mOggSyncState.clear();
            this.mVorbisBlock.clear();
            this.mVorbisDspState.clear();
            this.mVorbisInfo.clear();
            try {
                this.mIStream.close();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)iOException.toString());
            }
        }
        this.mIStream = null;
        this.mDecoderIsOpened = false;
        this.mEndOfStream = true;
    }
}

