/*
 * Decompiled with CFR 0.152.
 */
package games.stendhal.client.sprite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public class DataLoader {
    private static Logger logger = Logger.getLogger(DataLoader.class);
    private static Set<String> knownFiles = new HashSet<String>();
    private static Map<String, File> contentFilenameMapping = new HashMap<String, File>();
    private static Map<String, ZipFile> contentZipFilesMapping = new HashMap<String, ZipFile>();

    public static URL getResource(String string) {
        String string2 = DataLoader.stripLeadingSlash(string);
        File file = contentFilenameMapping.get(string2);
        if (file != null) {
            try {
                return new URL("jar:" + file.toURI().toASCIIString() + "!/" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)malformedURLException, (Throwable)malformedURLException);
            }
        }
        return DataLoader.class.getClassLoader().getResource(string2);
    }

    public static InputStream getResourceAsStream(String string) {
        String string2 = DataLoader.stripLeadingSlash(string);
        ZipFile zipFile = contentZipFilesMapping.get(string2);
        if (zipFile != null) {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            try {
                return zipFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
        return DataLoader.class.getClassLoader().getResourceAsStream(string2);
    }

    private static String stripLeadingSlash(String string) {
        if (string.length() < 1 || string.charAt(0) != '/') {
            return string;
        }
        return string.substring(1);
    }

    public static void addJarFile(String string) {
        try {
            if (knownFiles.contains(string)) {
                return;
            }
            File file = new File(string);
            if (!file.canRead()) {
                return;
            }
            knownFiles.add(string);
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                String string2 = DataLoader.stripLeadingSlash(zipEntry.getName());
                contentFilenameMapping.put(string2, file);
                contentZipFilesMapping.put(string2, zipFile);
            }
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }
}

